'use strict';
var visualizerApp = angular.module('app', ['ui.bootstrap', 'angular-inview', 'oc.lazyLoad', 'uploadimage', 'SocialMedia']);

visualizerApp.config(['$locationProvider', function ($locationProvider) {
    $locationProvider.html5Mode(true).hashPrefix();
}]);
visualizerApp.controller('visualizerCtrl',
    ['$scope', '$window', '$filter', '$uibModal', '$location', '$http', 'uploadimageService', 'ShareImage', '$anchorScroll',
        function ($scope, $window, $filter, $uibModal, $location, $http, uploadimageService, ShareImage, $anchorScroll) {


            $scope.index = 1;
            $scope.params = $location.search();

            var BacksplashResetUrl = "/glass-mosaics/adara-interlocking-8mm/";
            var BackSplashResetName = "Adara Interlocking 8MM";

            $scope.accordion = { Kitchen: true };
            $scope.baseURL = 'https://cdn.msisurfaces.com/images/visualizers/kitchen/';
            //$scope.baseURL = 'VisualizerResponsive/images/';

            $scope.sources = {};

            $scope.canvas = document.getElementById('myCanvas');

            $scope.context = $scope.canvas.getContext('2d');


            $scope.canvas2 = document.getElementById('myCanvas2');
            $scope.context2 = $scope.canvas2.getContext('2d');

            $scope.images = [];

            $scope.images2 = [];

            $scope.logoWaterMark = new Image();
            $scope.logoWaterMark.src = $scope.baseURL + "msilogo.png"

            $scope.imgHeight = 0;
            $scope.imgWidth = 0;

            $scope.initOptions = function (Options) {
                $scope.Options = Options;
                $scope.Reset();
            };

            $scope.setSource = function () {
              
                $scope.sources = {

                   
                    base: $scope.baseURL + $scope.Kitchen.BaseImg,
                    countertop: $scope.baseURL + $scope.Kitchen.Folder + '/' + $scope.CounterTop.Img,
                    backsplash: $scope.baseURL + $scope.Kitchen.Folder + '/' + $scope.BackSplash.Img,
                    cabinet: $scope.baseURL + $scope.Kitchen.Folder + '/' + $scope.CabinetColor.Img,
                    floor: $scope.baseURL + $scope.Kitchen.Folder + '/' + $scope.Floor.Img
                };

              

                if ($scope.Kitchen.Folder == "kitchen1") {
                    $scope.Kitchen2 = { "Folder": "kitchen2", "Type": ["k1"], BaseImg: "kitchen2base.png" };

                }
                else {

                    $scope.Kitchen2 = { "Folder": "kitchen52", "Type": ["k5"], BaseImg: "kitchen52base.jpg" };

                }


                $scope.sources2 = {
                    base: $scope.baseURL + $scope.Kitchen2.BaseImg,
                    countertop: $scope.baseURL + $scope.Kitchen2.Folder + '/' + $scope.CounterTop.Img,
                    backsplash: $scope.baseURL + $scope.Kitchen2.Folder + '/' + $scope.BackSplash.Img,
                    cabinet: $scope.baseURL + $scope.Kitchen2.Folder + '/' + $scope.CabinetColor.Img
                }

               
              



            };





            $scope.Reset = function () {
                var CounterTopId = 308;
                var BacksplashId = 362;
                var FloorId = 121;
                var kitchenType
                $scope.currentPage = 1;

                $scope.Kitchen = { "Folder": "kitchen51", "Type": ["k5"], BaseImg: "kitchen51base.jpg" };

                $scope.Kitchen2 = { "Folder": "kitchen52", "Type": ["k5"], BaseImg: "kitchen52base.jpg" };

                kitchenType = $filter("filter")($scope.Options.CounterTops, { ID: CounterTopId })[0];
                if ($scope.params != undefined && $scope.params.cntps != undefined) {
                    // t= Countertop ; f= floor; p = backsplash
                    var selection = $scope.params.cntps.substring(0, 1).toUpperCase();

                    switch (selection) {
                        case "T":
                            CounterTopId = parseInt($scope.params.cntps.substring(1));

                            kitchenType = $filter("filter")($scope.Options.CounterTops, { ID: CounterTopId })[0];
                            break;
                        case "F":
                            FloorId = parseInt($scope.params.cntps.substring(1));
                            kitchenType = $filter("filter")($scope.Options.Floors, { ID: FloorId })[0];
                            break;
                        case "P":
                            BacksplashId = parseInt($scope.params.cntps.substring(1));
                            kitchenType = $filter("filter")($scope.Options.Backsplashs, { ID: BacksplashId })[0];
                            break;
                        default:
                            console.error("Invalid Query String", $scope.params.cntps);
                    }
                }



                var tempOpt = $filter("filter")($scope.Options.CounterTops, { ID: CounterTopId });
                if (tempOpt.length == 0) {
                    tempOpt = [$scope.Options.CounterTops[0]];
                    console.error("Invalid Countertop Id", CounterTopId);
                }
                $scope.CounterTop = { ID: tempOpt[0].ID, Img: "vs" + ("0000" + tempOpt[0].ID).slice(-4) + "ct.png", URL: tempOpt[0].PageURL, Name: tempOpt[0].Name, NaturalStone: true, Quartz: true, StilePorcelainSlab:false };


                tempOpt = $filter("filter")($scope.Options.Backsplashs, { ID: BacksplashId });
                if (tempOpt.length == 0) {
                    tempOpt = [$scope.Options.Backsplashs[0]];
                    console.error("Invalid Backsplash Id", BacksplashId);
                }
                $scope.BackSplash = { ID: tempOpt[0].ID, Img: "vs" + ("0000" + tempOpt[0].ID).slice(-4) + "bl.png", URL: tempOpt[0].PageURL, Name: tempOpt[0].Name};

                tempOpt = $filter("filter")($scope.Options.Cabinets, { ID: 22 });
                if (tempOpt.length == 0) {
                    tempOpt = [$scope.Options.Cabinets[0]];
                    console.error("Invalid Cabinets Id", 1);
                }
                $scope.CabinetColor = { ID: tempOpt[0].ID, Img: "vs" + ("0000" + tempOpt[0].ID).slice(-4) + "cb.png", Name: tempOpt[0].Name };

                tempOpt = $filter("filter")($scope.Options.Floors, { ID: FloorId });
                if (tempOpt.length == 0) {
                    tempOpt = [$scope.Options.Floors[0]];
                    console.error("Invalid Floor Id", FloorId);
                }
                $scope.Floor = { ID: tempOpt[0].ID, Img: "vs" + ("0000" + tempOpt[0].ID).slice(-4) + "fl.png", URL: tempOpt[0].PageURL, Name: tempOpt[0].Name };



                $scope.CTASBL = false;

                // select Kitchen based on Query string
                if (kitchenType == undefined) {
                    $scope.currentPage = 1;
                    $scope.SelectKitchen(0);
                }
                else if (kitchenType.KitchenGroup.toUpperCase().indexOf("k5") >= 0) {
                    $scope.currentPage = 1;
                    $scope.SelectKitchen(0);

                }
                else if (kitchenType.KitchenGroup.toUpperCase().indexOf("k1") >= 0) {
                    $scope.currentPage = 2;
                    $scope.SelectKitchen(1);

                }

                else {
                    $scope.currentPage = 1;
                    $scope.SelectKitchen(0);
                }

                // $scope.setSource();
            };

            $scope.loadImages = function (images, sources, callback) {

                
                // var images = {};
                var loadedImages = 0;
                var numImages = 0;
                // get num of sources
                for (var src in sources) {
                    numImages++;

                }

                for (var src in sources) {
                    images[src] = new Image();
                   images[src].crossOrigin = "Anonymous";
                    images[src].class = "img-responsiveHeight";
                    images[src].onload = function () {
                        //console.log(loadedImages);
                        if (++loadedImages >= numImages) {
                            callback(images);
                        }
                    };
                  
                    images[src].src = sources[src];


                }
            };

            $scope.ElementInView = function (index, inview, eleName) {
                var img = angular.element(document.getElementById(eleName + "[" + index + "]"));


                if (inview) {
                    img.attr('src', img.attr("smart-src"));

                }
            };

            $scope.SelectKitchen = function (kitchenIndex) {

                $scope.index = kitchenIndex;

                $scope.ChangeKitchen({ "Folder": $scope.Options.VisualizerTypes[kitchenIndex].folder, "Type": [$scope.Options.VisualizerTypes[kitchenIndex].TypeOfVisualizer], "BaseImg": $scope.Options.VisualizerTypes[kitchenIndex].BaseImg, "SecondView": false });

            };

            $scope.ChangeCT = function (ct) {

                $scope.CounterTop.ID = ct.ID;
                $scope.CounterTop.URL = ct.PageURL;
                $scope.CounterTop.Name = ct.Name;
                $scope.CounterTop.Img = "vs" + ("0000" + ct.ID).slice(-4) + "ct.png";
                $scope.images.countertop.src = $scope.baseURL + $scope.Kitchen.Folder + '/' + $scope.CounterTop.Img;

                $scope.images2.countertop.src = $scope.baseURL + $scope.Kitchen2.Folder + '/' + $scope.CounterTop.Img;

                if ($scope.BackSplash.CTASBL) {
                    $scope.BackSplash.URL = ct.PageURL;
                    $scope.BackSplash.Name = ct.Name;
                    // $scope.BackSplash.ImgAsCt = "CTasBL-" + $scope.Kitchen.Type[0] + "/VS" + ("0000" + ct.ID).slice(-4) + "BL.png";
                    $scope.images.backsplash.src = $scope.baseURL + $scope.Kitchen.Folder + "/vs" + ("0000" + $scope.CounterTop.ID).slice(-4) + "bc.png";
                    $scope.images2.backsplash.src = $scope.baseURL + $scope.Kitchen2.Folder + "/vs" + ("0000" + $scope.CounterTop.ID).slice(-4) + "bc.png";

                }
                $scope.LogKitchen("Countertop", $scope.CounterTop.Name);

                if (parent == window) {
                    document.getElementById('lblHeading').scrollIntoView({
                        behavior: "smooth",
                        block: "start",
                    });
                }
            };

            $scope.ChangeBL = function (bl) {

                $scope.BackSplash.CTASBL = false;
                $scope.BackSplash.ID = bl.ID;
                $scope.BackSplash.URL = bl.PageURL;
                $scope.BackSplash.Name = bl.Name;
                BacksplashResetUrl = bl.PageURL;
                BackSplashResetName = bl.Name;

                $scope.BackSplash.Img = "vs" + ("0000" + bl.ID).slice(-4) + "bl.png";
                $scope.images.backsplash.src = $scope.baseURL + $scope.Kitchen.Folder + '/' + $scope.BackSplash.Img;
                $scope.images2.backsplash.src = $scope.baseURL + $scope.Kitchen2.Folder + '/' + $scope.BackSplash.Img;
                $scope.LogKitchen("BackSplash", $scope.BackSplash.Name);
                if (parent == window) {
                    document.getElementById('lblHeading').scrollIntoView({
                        behavior: "smooth",
                        block: "start",
                    });
                }
            };

            $scope.ChangeCB = function (cb) {
                $scope.CabinetColor.ID = cb.ID;
                $scope.CabinetColor.Name = cb.Name
                $scope.CabinetColor.Img = "vs" + ("0000" + cb.ID).slice(-4) + "cb.png";
                $scope.images.cabinet.src = $scope.baseURL + $scope.Kitchen.Folder + '/' + $scope.CabinetColor.Img;
                $scope.images2.cabinet.src = $scope.baseURL + $scope.Kitchen2.Folder + '/' + $scope.CabinetColor.Img;
                $scope.LogKitchen("Cabinet", $scope.CabinetColor.Name);
                if (parent == window) {
                    document.getElementById('lblHeading').scrollIntoView({
                        behavior: "smooth",
                        block: "start",
                    });
                }
            };

            $scope.ChangeFL = function (fl) {
                $scope.Floor.ID = fl.ID;
                $scope.Floor.URL = fl.PageURL;
                $scope.Floor.Name = fl.Name
                $scope.Floor.Img = "vs" + ("0000" + fl.ID).slice(-4) + "fl.png";
                $scope.images.floor.src = $scope.baseURL + $scope.Kitchen.Folder + '/' + $scope.Floor.Img;
                $scope.LogKitchen("Floor", $scope.Floor.Name);
                if (parent == window) {
                    document.getElementById('lblHeading').scrollIntoView({
                        behavior: "smooth",
                        block: "start",
                    });
                }

            };
            //use countertop for backsplah section //
            $scope.setBL_As_CT = function () {


                if ($scope.BackSplash.CTASBL) {



                    $scope.BackSplash.URL = $scope.CounterTop.URL;
                    $scope.BackSplash.Name = $scope.CounterTop.Name;


                    $scope.images.backsplash.src = $scope.baseURL + $scope.Kitchen.Folder + "/vs" + ("0000" + $scope.CounterTop.ID).slice(-4) + "bc.png";
                    $scope.images2.backsplash.src = $scope.baseURL + $scope.Kitchen2.Folder + "/vs" + ("0000" + $scope.CounterTop.ID).slice(-4) + "bc.png";

                }
                else {
                    $scope.BackSplash.URL = BacksplashResetUrl;
                    $scope.BackSplash.Name = BackSplashResetName;


                    $scope.images.backsplash.src = $scope.baseURL + $scope.Kitchen.Folder + "/vs" + ("0000" + $scope.BackSplash.ID).slice(-4) + "bl.png";
                    $scope.images2.backsplash.src = $scope.baseURL + $scope.Kitchen2.Folder + "/vs" + ("0000" + $scope.BackSplash.ID).slice(-4) + "bl.png";

                }
            };

            $scope.ChangeKitchen = function (kitchen) {
                $scope.Kitchen = kitchen;

                $scope.setSource();
                if ($scope.BackSplash.CTASBL && $scope.Kitchen.Type.join(',').indexOf('k5') < 0) {
                    $scope.sources.backsplash = $scope.baseURL + $scope.Kitchen.Folder + "/vs" + ("0000" + $scope.CounterTop.ID).slice(-4) + "bc.png";
                    $scope.sources2.backsplash = $scope.baseURL + $scope.Kitchen2.Folder + "/vs" + ("0000" + $scope.CounterTop.ID).slice(-4) + "bc.png";

                }
            };


            $scope.updateCanvas = function (images) {

               
                var baseImg = new Image();

                baseImg.crossOrigin = "Anonymous";
                baseImg.src = images.base.src;

                var countertopImg = new Image();

                countertopImg.crossOrigin = "Anonymous";
                countertopImg.src = images.countertop.src;

                var backsplashImg = new Image();

                backsplashImg.crossOrigin = "Anonymous";
                backsplashImg.src = images.backsplash.src;

                var cabinetImg = new Image();

                cabinetImg.crossOrigin = "Anonymous";
                cabinetImg.src = images.cabinet.src;


                var floortileImg = new Image();

                floortileImg.crossOrigin = "Anonymous";
                floortileImg.src = images.floor.src;

                if ($scope.imgHeight == 0) {
                    $scope.imgHeight = images.base.height;
                    $scope.imgWidth = images.base.width;
                }
                $scope.canvas.height = $scope.imgHeight;
                $scope.canvas.width = $scope.imgWidth;
                $scope.context.restore();
                $scope.context.drawImage(baseImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                if (images.countertop) {
                   
                    $scope.context.drawImage(countertopImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                }
                if (images.backsplash) {
                    $scope.context.drawImage(backsplashImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                }
                if (images.cabinet) {
                    $scope.context.drawImage(cabinetImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                }
                if (images.floor) {
                    $scope.context.drawImage(floortileImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                }
                //console.log(images.floor);
                //if ($scope.Kitchen.Type[0] == 'K5') {
                //   $scope.updateCanvas2(images);
                //}
            };

            $scope.updateCanvas2 = function (images) {
                
                var baseImg = new Image();

                baseImg.crossOrigin = "Anonymous";
                baseImg.src = images.base.src;

                var countertopImg = new Image();

                countertopImg.crossOrigin = "Anonymous";
                countertopImg.src = images.countertop.src;

                var backsplashImg = new Image();

                backsplashImg.crossOrigin = "Anonymous";
                backsplashImg.src = images.backsplash.src;

                var cabinetImg = new Image();

                cabinetImg.crossOrigin = "Anonymous";
                cabinetImg.src = images.cabinet.src;


                


                if ($scope.imgHeight == 0) {
                    $scope.imgHeight = images.base.height;
                    $scope.imgWidth = images.base.width;
                }
                $scope.canvas2.height = $scope.imgHeight;
                $scope.canvas2.width = $scope.imgWidth;
                $scope.context2.restore();

                $scope.context2.drawImage(baseImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                if (images.countertop) {
                    $scope.context2.drawImage(countertopImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                }
                if (images.backsplash) {
                    $scope.context2.drawImage(backsplashImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                }
                if (images.cabinet) {
                    $scope.context2.drawImage(cabinetImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                }
                //$scope.context2.drawImage(images.floor, 0, 0, $scope.imgWidth, $scope.imgHeight);

            };

            $scope.AddDetailsToCanvas = function (images, hideDetails) {


                var baseImg = new Image();

                baseImg.crossOrigin = "Anonymous";
                baseImg.src = images.base.src;

                var countertopImg = new Image();

                countertopImg.crossOrigin = "Anonymous";
                countertopImg.src = images.countertop.src;

                var backsplashImg = new Image();

                backsplashImg.crossOrigin = "Anonymous";
                backsplashImg.src = images.backsplash.src;

                var cabinetImg = new Image();

                cabinetImg.crossOrigin = "Anonymous";
                cabinetImg.src = images.cabinet.src;


                var floortileImg = new Image();

                floortileImg.crossOrigin = "Anonymous";
                floortileImg.src = images.floor.src;


                var watermarkImg = new Image();

                watermarkImg.crossOrigin = "Anonymous";
                watermarkImg.src = $scope.logoWaterMark.src;



                hideDetails = hideDetails || false;
                var lineHeight = 16;
                if (hideDetails) {
                    $scope.canvas.height = $scope.imgHeight;
                }
                else {
                    $scope.canvas.height = $scope.imgHeight + (lineHeight * 5) + 10;
                }


                $scope.canvas.width = $scope.imgWidth;
                $scope.context.restore();


                $scope.context.drawImage(baseImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                if (images.countertop) {
                    $scope.context.drawImage(countertopImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                }
                if (images.backsplash) {
                    $scope.context.drawImage(backsplashImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                }
                if (images.cabinet) {
                    $scope.context.drawImage(cabinetImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                }
                if (images.floor) {
                    $scope.context.drawImage(floortileImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                }
                $scope.context.drawImage(watermarkImg, $scope.imgWidth - $scope.logoWaterMark.width - 10, $scope.imgHeight - $scope.logoWaterMark.height - 10);
                if (!hideDetails) {
                    $scope.context.font = lineHeight + "px Arial";

                    $scope.context.fillText("My Kitchen Visualizer Design", 10, $scope.imgHeight + (lineHeight * 1));

                    $scope.context.fillText("Countertop", 10, $scope.imgHeight + (lineHeight * 2));
                    $scope.context.fillText(": " + $scope.CounterTop.Name, 100, $scope.imgHeight + (lineHeight * 2));

                    $scope.context.fillText("Backsplash", 10, $scope.imgHeight + (lineHeight * 3));
                    $scope.context.fillText(": " + $scope.BackSplash.Name, 100, $scope.imgHeight + (lineHeight * 3));

                    $scope.context.fillText("Cabinet", 10, $scope.imgHeight + (lineHeight * 4));
                    $scope.context.fillText(": " + $scope.CabinetColor.Name, 100, $scope.imgHeight + (lineHeight * 4));

                    $scope.context.fillText("Floor", 10, $scope.imgHeight + (lineHeight * 5));
                    $scope.context.fillText(": " + $scope.Floor.Name, 100, $scope.imgHeight + (lineHeight * 5));
                }
            };

            $scope.AddDetailsToCanvas2 = function (images, hideDetails) {

                var baseImg = new Image();

                baseImg.crossOrigin = "Anonymous";
                baseImg.src = images.base.src;

                var countertopImg = new Image();

                countertopImg.crossOrigin = "Anonymous";
                countertopImg.src = images.countertop.src;

                var backsplashImg = new Image();

                backsplashImg.crossOrigin = "Anonymous";
                backsplashImg.src = images.backsplash.src;

                var cabinetImg = new Image();

                cabinetImg.crossOrigin = "Anonymous";
                cabinetImg.src = images.cabinet.src;

                var watermarkImg = new Image();

                watermarkImg.crossOrigin = "Anonymous";
                watermarkImg.src = $scope.logoWaterMark.src;
                



                hideDetails = hideDetails || false;
                var lineHeight = 16;
                if (hideDetails) {
                    $scope.canvas2.height = $scope.imgHeight;
                }
                else {
                    $scope.canvas2.height = $scope.imgHeight + (lineHeight * 5) + 10;
                }


                $scope.canvas2.width = $scope.imgWidth;
                $scope.context2.restore();


                $scope.context2.drawImage(baseImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                if (images.countertop) {
                    $scope.context2.drawImage(countertopImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                }
                if (images.backsplash) {
                    $scope.context2.drawImage(backsplashImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                }
                if (images.cabinet) {
                    $scope.context2.drawImage(cabinetImg, 0, 0, $scope.imgWidth, $scope.imgHeight);
                }
                // $scope.context2.drawImage(images.floor, 0, 0, $scope.imgWidth, $scope.imgHeight);
                $scope.context2.drawImage(watermarkImg, $scope.imgWidth - $scope.logoWaterMark.width - 10, $scope.imgHeight - $scope.logoWaterMark.height - 10);

                if (!hideDetails) {

                    $scope.context2.font = lineHeight + "px Arial";

                    $scope.context2.fillText("My Kitchen Visualizer Design", 10, $scope.imgHeight + (lineHeight * 1));

                    $scope.context2.fillText("Countertop", 10, $scope.imgHeight + (lineHeight * 2));
                    $scope.context2.fillText(": " + $scope.CounterTop.Name, 100, $scope.imgHeight + (lineHeight * 2));

                    $scope.context2.fillText("Backsplash", 10, $scope.imgHeight + (lineHeight * 3));
                    $scope.context2.fillText(": " + $scope.BackSplash.Name, 100, $scope.imgHeight + (lineHeight * 3));

                    $scope.context2.fillText("Cabinet", 10, $scope.imgHeight + (lineHeight * 4));
                    $scope.context2.fillText(": " + $scope.CabinetColor.Name, 100, $scope.imgHeight + (lineHeight * 4));
                }
                // $scope.context2.fillText("Floor", 10, $scope.imgHeight + (lineHeight * 5));
                // $scope.context2.fillText(": " + $scope.Floor.Name, 100, $scope.imgHeight + (lineHeight * 5));

            };

            $scope.initCanvas = function () {
                //console.log("initCalled");
                $scope.loadImages($scope.images, $scope.sources, $scope.updateCanvas);
                $scope.loadImages($scope.images2, $scope.sources2, $scope.updateCanvas2);
            };

            $scope.getCanvasImg = function () {


                $scope.AddDetailsToCanvas($scope.images);

                $scope.canvas.toBlob(function (blob) {
                    saveAs(blob, "My_Kitchen_Design.png");
                });
                $scope.updateCanvas($scope.images);


                $scope.AddDetailsToCanvas2($scope.images2);
                $scope.canvas2.toBlob(function (blob) {
                    saveAs(blob, "My_Kitchen_Design_2.png");
                });
                $scope.updateCanvas2($scope.images2);

            };

            $scope.printKitchen = function () {

             
                $scope.AddDetailsToCanvas($scope.images, true);
                $scope.AddDetailsToCanvas2($scope.images2, true);
                var dataUrl = $scope.canvas.toDataURL("image/png"); //attempt to save base64 string to server using this var
             
                var dataUrl2 = $scope.canvas2.toDataURL("image/png");

                var windowContent = '<!DOCTYPE html>';
                windowContent += '<html>';
                windowContent += '<head><title>My Kitchen Design</title></head>';
                windowContent += '<body>';
                windowContent += '<img src="' + dataUrl + '" style="max-width:100%;height:auto;"/>';
                windowContent += '<table style="width:100%;">';
                windowContent += '<tr><td colspan="2" style="text-align:center;"><h2>My Kitchen Design</h2></td></tr>';
                windowContent += '<tr><td><b>Countertop</b></td><td style="width:100%;">' + $scope.CounterTop.Name + '</td></tr>';
                windowContent += '<tr><td><b>Backsplash</b></td><td>' + $scope.BackSplash.Name + '</td></tr>';
                windowContent += '<tr><td><b>Cabinet</b></td><td>' + $scope.CabinetColor.Name + '</td></tr>';
                windowContent += '<tr><td><b>Floor</b></td><td>' + $scope.Floor.Name + '</td></tr>';
                windowContent += '</table>';

                windowContent += '<div style="page-break-after: always;"> </div>';
                windowContent += '<img src="' + dataUrl2 + '" style="max-width:100%;height:auto;"/>';
                windowContent += '<table style="width:100%;">';
                windowContent += '<tr><td colspan="2" style="text-align:center;"><h2>My Kitchen Design</h2></td></tr>';
                windowContent += '<tr><td><b>Countertop</b></td><td style="width:100%;">' + $scope.CounterTop.Name + '</td></tr>';
                windowContent += '<tr><td><b>Backsplash</b></td><td>' + $scope.BackSplash.Name + '</td></tr>';
                windowContent += '<tr><td><b>Cabinet</b></td><td>' + $scope.CabinetColor.Name + '</td></tr>';
                windowContent += '</table>';

                windowContent += '</body>';
                windowContent += '</html>';
                var printWin = window.open('', '', 'width=680,height=520');
                printWin.document.open();
                printWin.document.write(windowContent);
                printWin.document.close();
                setTimeout(function () {
                    printWin.focus();
                    printWin.print();
                    $scope.updateCanvas($scope.images);
                    $scope.updateCanvas2($scope.images2);
                    printWin.close();
                }, 250);
            };

            $scope.$watch('sources', $scope.initCanvas);

            $scope.LogKitchen = function (ItemType, ItemName) {
                var Logdetails = { "ItemType": ItemType, "ItemName": ItemName, "KitchenName": $scope.Kitchen.Folder.substring(0, 8) };
                var isInIframe = (parent !== window),
                    parentUrl = null;

                if (isInIframe) {
                    parentUrl = document.referrer;
                    if (parentUrl == '')
                        parentUrl = window.location.href;
                }
                Logdetails.websiteURL = parentUrl;

                $http({
                    url: "/virtual-kitchen-designer/api/miscellaneous/logkitchen/",
                    method: "GET",
                    params: Logdetails
                }).then(function successCallback(data) {
                    console.log(data);
                }, function errorCallback(response) {
                    console.log(response);
                });
                //alert( window.location.href);
                //alert( document.referrer);
            };

            //$(window).resize(function () {
            //    $scope.ShowOptionDiv("divCT");
            //    //$scope.$apply(function () {
            //    //    $scope.windowWidth = $(window).width();
            //    //});
            //});

            $scope.ShowOptionDiv = function (divId) {

                document.getElementById('divCT').classList.add("hidden-xs");
                document.getElementById('divBL').classList.add("hidden-xs");
                document.getElementById('divCB').classList.add("hidden-xs");
                document.getElementById('divFL').classList.add("hidden-xs");
                document.getElementById(divId).classList.remove("hidden-xs");

                document.getElementById('divCT_Btn').classList.remove("hidden-xs");
                document.getElementById('divBL_Btn').classList.remove("hidden-xs");
                document.getElementById('divCB_Btn').classList.remove("hidden-xs");
                document.getElementById('divFL_Btn').classList.remove("hidden-xs");
                document.getElementById(divId + '_Btn').classList.add("hidden-xs");

                //
                document.getElementById('chkNS').classList.add("hidden-xs");
                document.getElementById('chkQ').classList.add("hidden-xs");
                document.getElementById('chkStile').classList.add("hidden-xs");
                document.getElementById('lblNew').classList.add("hidden-xs");

                var chkBL = document.getElementById("chk").checked;


                if (divId === "divCT") {
                    document.getElementById('chkNS').classList.remove("hidden-xs");
                    document.getElementById('chkQ').classList.remove("hidden-xs");
                    document.getElementById('chkStile').classList.remove("hidden-xs");
                    document.getElementById('lblNew').classList.remove("hidden-xs");
                    document.getElementById('chkBL').classList.remove("hidden-xs");
                }
                else if (divId === "divBL") {

                    if (chkBL) {
                        document.getElementById('chkBL').classList.remove("hidden-xs");
                    }
                    else {
                        document.getElementById('chkBL').classList.add("hidden-xs");
                    }
                }
                else if (divId === "divCB") {
                    document.getElementById('chkBL').classList.add("hidden-xs");
                }
                else if (divId === "divFL") {
                    document.getElementById('chkBL').classList.add("hidden-xs");
                }
            }

            // For E-Mail pop-up
            $scope.openEmailDailog = function (size, parentSelector) {

                var parentElem = parentSelector ?
                    angular.element($document[0].querySelector('.modal-demo ' + parentSelector)) : undefined;
                $scope.AddDetailsToCanvas($scope.images);
                $scope.AddDetailsToCanvas2($scope.images2);
                var modalInstance = $uibModal.open({
                    animation: false,
                    ariaLabelledBy: 'modal-title',
                    ariaDescribedBy: 'modal-body',
                    templateUrl: 'Templates/EmailDailog.html',
                    controller: 'EmailModalCtrl',
                    controllerAs: 'emailCtrlr',
                    backdrop: 'static',
                    size: size,
                    appendTo: parentElem,
                    resolve: {
                        deps: ["$ocLazyLoad", function ($ocLazyLoad) {
                            return $ocLazyLoad.load({
                                name: "app",
                                insertBefore: "#Headers",
                                files: [
                                    "Content/Trix.css",
                                    "Content/Chip.css",
                                    "Scripts/Trix/Trix.js",
                                    "Scripts/Trix/angularTrix.js",
                                    "Scripts/Chips/angular-chip.js",
                                    "Scripts/app/Controllers/EmailController.js"]
                            });
                        }],
                        model: function () {
                            return {
                                "kitchenImg": $scope.canvas,
                                "kitchenImg2": $scope.canvas2,
                                "CounterTop": $scope.CounterTop,
                                "BackSplash": $scope.BackSplash,
                                "CabinetColor": $scope.CabinetColor,
                                "Floor": $scope.Floor

                            };
                        }
                    }
                });

                $scope.updateCanvas($scope.images);
                $scope.updateCanvas2($scope.images2);

                modalInstance.result.then(function (selectedItem) {


                }, function () {
                    // $log.info('E-Mail Modal dismissed at: ' + new Date());
                });

            };

            // Social Media Sharing : Facebook
            $scope.shareFB = function () {

                $scope.AddDetailsToCanvas($scope.images);
                var data = $scope.canvas.toDataURL("image/png");

                try {
                    var blob = dataURItoBlob(data);

                    var fd = new FormData();
                    fd.append("Name", "KitchenVisualizer");
                    var fileName = "VKD_V1_CT" + $scope.CounterTop.ID + "BL" + $scope.BackSplash.ID + "CC" + $scope.CabinetColor.ID + "FL" + $scope.Floor.ID
                    fd.append(fileName, blob);

                    uploadimageService.post(fd).then(function successCallback(data) {
                        var Opt = {
                            product_name: "Your Customized Kitchen Design",
                            share_url: "www.msisurfaces.com/virtual-kitchen-designer",
                            share_image: data.data[0],
                            share_capt: "MSI | Kitchen Visualizer",
                            description: "Countertop : " + $scope.CounterTop.Name + ", Backsplash : " + $scope.BackSplash.Name + ", Floor : " + $scope.CabinetColor.Name + ", Cabinet : " + $scope.Floor.Name + ""
                        };

                        ShareImage.ToFB(Opt).then(function successCallback(data) {
                            console.log(data);
                        }, function errorCallback(response) {
                            console.log("error ", response);
                        });
                    }, function errorCallback(response) {
                        console.log("error ", response);
                    });

                } catch (e) {
                    console.log(e);
                }
                $scope.updateCanvas($scope.images);
            };

            $scope.shareTwitter = function () {
                $scope.AddDetailsToCanvas($scope.images);
                var data = $scope.canvas.toDataURL("image/png");

                try {
                    var blob = dataURItoBlob(data);

                    var fd = new FormData();
                    fd.append("Name", "KitchenVisualizer");
                    var fileName = "VKD_V1_CT" + $scope.CounterTop.ID + "BL" + $scope.BackSplash.ID + "CC" + $scope.CabinetColor.ID + "FL" + $scope.Floor.ID
                    fd.append(fileName, blob);

                    uploadimageService.post(fd).then(function successCallback(data) {
                        ShareImage.ToTwitter(data.data[0]);
                    }, function errorCallback(response) {
                        console.log("error ", response);
                    });
                } catch (e) {
                    console.log(e);
                }
                $scope.updateCanvas($scope.images);
            };

            $scope.sharePinterest = function () {
                $scope.AddDetailsToCanvas($scope.images);
                var data = $scope.canvas.toDataURL("image/png");

                try {
                    var blob = dataURItoBlob(data);

                    var fd = new FormData();
                    fd.append("Name", "KitchenVisualizer");
                    var fileName = "VKD_V1_CT" + $scope.CounterTop.ID + "BL" + $scope.BackSplash.ID + "CC" + $scope.CabinetColor.ID + "FL" + $scope.Floor.ID
                    fd.append(fileName, blob);

                    uploadimageService.post(fd).then(function successCallback(data) {
                        ShareImage.ToPinterest(data.data[0]);
                    }, function errorCallback(response) {
                        console.log("error ", response);
                    });
                } catch (e) {
                    console.log(e);
                }
                $scope.updateCanvas($scope.images);
            };

            $scope.shareGoogle = function () {
                $scope.AddDetailsToCanvas($scope.images);
                var data = $scope.canvas.toDataURL("image/png");

                try {
                    var blob = dataURItoBlob(data);
                    var fd = new FormData();
                    fd.append("Name", "KitchenVisualizer");
                    var fileName = "VKD_V1_CT" + $scope.CounterTop.ID + "BL" + $scope.BackSplash.ID + "CC" + $scope.CabinetColor.ID + "FL" + $scope.Floor.ID
                    fd.append(fileName, blob);

                    uploadimageService.post(fd).then(function successCallback(data) {
                        ShareImage.ToGooglePlus(data.data[0]);
                    }, function errorCallback(response) {
                        console.log("error ", response);
                    });
                } catch (e) {
                    console.log(e);
                }
                $scope.updateCanvas($scope.images);
            };
        }]);

function dataURItoBlob(dataURI) {

    var byteString = atob(dataURI.split(',')[1]);
    var ab = new ArrayBuffer(byteString.length);
    var ia = new Uint8Array(ab);
    for (var i = 0; i < byteString.length; i++) {
        ia[i] = byteString.charCodeAt(i);
    }
    return new Blob([ia], { type: 'image/png' });

}

visualizerApp.filter('filterByKitchen', function () {
    return function (items, KitchenType) {
        var filtered = [];
        angular.forEach(items, function (item) {
            if (item.KitchenGroup.toUpperCase().indexOf(KitchenType.join(",")) >= 0) {
                filtered.push(item);
            }
        });
        return filtered;
    };
});

visualizerApp.filter('filterByNS', function () {
    return function (items, Countertop) {
        
        var filtered = [];
      
        angular.forEach(items, function (item) {
            if ((item.MaterialType.toUpperCase().indexOf("NATURAL") >= 0 && Countertop.NaturalStone) || (item.MaterialType.toUpperCase().indexOf("QUARTZ") >= 0 && Countertop.Quartz) || (item.MaterialType.toUpperCase().indexOf("STILE") >= 0 && Countertop.StilePorcelainSlab)) {
                filtered.push(item);
            }
        });
        if (filtered.length == 0) {
            angular.forEach(items, function (item1) {
               
                    filtered.push(item1);
                
            });
        }
        return filtered;
    };
});

visualizerApp.filter('filterByStileBacksplash', function () {
   
    return function (items, Countertop) {

        var filtered = [];  
        angular.forEach(items, function (item) {
            if ((item.MaterialType.toUpperCase().indexOf("NATURAL") >= 0 && Countertop.NaturalStone) || (item.MaterialType.toUpperCase().indexOf("QUARTZ") >= 0 && Countertop.Quartz) || (item.MaterialType.toUpperCase().indexOf("STILE") >= 0 && Countertop.StilePorcelainSlab)) {
                filtered.push(item);
            }
        });
        if (filtered.length == 0) {
            angular.forEach(items, function (item1) {
               
                    filtered.push(item1);
                
            });
        }
        
        return filtered;
    };
});
visualizerApp.filter('filterByStileFloor', function () {

    return function (items, Countertop) {

        var filtered = [];

        angular.forEach(items, function (item) {


            if (item.MaterialType.toUpperCase().indexOf("STILE") >= 0 && Countertop.StilePorcelainSlab) {

                filtered.push(item);
            }

            else if (item.MaterialType.toUpperCase().indexOf("STILE") < 0 && !Countertop.StilePorcelainSlab) {

                filtered.push(item);
            }

        });

        return filtered;
    };
});

visualizerApp.filter('unique', function () {
    return function (items, filterOn) {

        if (filterOn === false) {
            return items;
        }

        if ((filterOn || angular.isUndefined(filterOn)) && angular.isArray(items)) {
            var hashCheck = {}, newItems = [];

            var extractValueToCompare = function (item) {
                if (angular.isObject(item) && angular.isString(filterOn)) {
                    return item[filterOn];
                } else {
                    return item;
                }
            };

            angular.forEach(items, function (item) {
                var valueToCheck, isDuplicate = false;

                for (var i = 0; i < newItems.length; i++) {
                    if (angular.equals(extractValueToCompare(newItems[i]), extractValueToCompare(item))) {
                        isDuplicate = true;
                        break;
                    }
                }
                if (!isDuplicate) {
                    newItems.push(item);
                }

            });
            items = newItems;
        }
        return items;
    };
});

visualizerApp.directive('smartSrc', function () {
    return {
        restrict: 'A', //attribute directive
        scope: { //isolate scope
            smartSrc: '@', //smart src
            smartSrcWatch: '&' //$watch hook
        },
        link: function (scope, element) {
            //cache for cleanup
            var unwatcher = scope.$watch(scope.smartSrcWatch, function (newVal) {
                //validate $watch
                console.log(newVal);
                if (newVal) {
                    //add src
                    element.attr('src', scope.smartSrc);
                    //cleanup
                    unwatcher();
                }
            });
        }
    };
});