var vinAngular = angular.module('vinAngularApp', [

]);

(function () {
	angular.module('vinAngularApp').directive('ngVinCeRtsZoomWebinar', function ($http) {
		return {
			scope: {
				classid: '@'
			},
			restrict: 'A',
			templateUrl: '/Global/JS/angular/vin.ce.rts.zoom.webinar.template.html',
			link: function (scope, element, attrs) {

			}
		};
	});


	angular.module('vinAngularApp').directive('ngVinCeAdminSelfStudy', ['$http', function ($http) {
		return {
			scope: {
				classid: '@'
			},
			restrict: 'A',
			templateUrl: '/Global/JS/angular/vin.ce.admin.selfstudy.template.html',
			link: {
				post: function (scope, element, attrs) {
					var apiBase = '/a/ce/v1';
					scope.jsonValid = false;

					scope.partRawdata = {};
					scope.partDataLoaded = false;
					scope.partDataLoadError = false;
					scope.noParticipants = true;
					scope.partData = {};
					scope.parseErrors = [];

					scope.partRawnamedata = {};
					scope.partNameData = {};

					scope.courseDataLoaded = false;
					scope.courseDataLoadError = false;
					scope.courseDataLoadErrorMessage = '';
					scope.courseRawdata = {};
					scope.courseInit = false;
					scope.version = 0;
					scope.courseData = 0;
					scope.courseJson = '';

					scope.displayConfirm = false;
					scope.confirmed = false;
					scope.confirmPartId = 0;
					scope.confirmMatch = '';
					scope.confirmDefferedFunc = null;

					scope.submittedExpanded = true;
					scope.inProgressExpanded = false;
					scope.notEnrolledExpanded = false;
					scope.certificateAwardedExpanded = false;

					scope.loadData = function () {
						scope.partDataLoaded = false;
						scope.partDataLoadError = false;
						scope.courseDataLoaded = false;
						scope.courseDataLoadError = false;
						scope.parseErrors = [];
						$http.get(apiBase + '/takes/grouped/' + scope.classid).then(
							function (res) {
								scope.partRawdata = res.data;
								scope.partDataLoaded = true;
								scope.partData = res.data.response_data;
								for (var key in res.data.response_data) {
									var item = res.data.response_data[key];
									if (Array.isArray(item) && item.length > 0) {
										scope.noParticipants = false;
										break;
									}
								}
							}
						).catch(function (err) {
							console.log(err.data);
							if (err.data.error) {
								scope.partRawdata = err;
								scope.partDataLoaded = true;
							} else {
								scope.partDataLoadError = true;
							}

						})

						$http.get(apiBase + '/participants/' + scope.classid).then(
							function (res) {
								scope.partRawnamedata = res.data;
								scope.partNameData = res.data.response_data;


							}
						).catch(function (err) {
							console.log(err.data);
							if (err.data.error) {
								scope.partRawdata = err;
								scope.partDataLoaded = true;

							} else {
								scope.partDataLoadError = true;
							}

						})

						$http.get(apiBase + '/course/' + scope.classid).then(
							function (res) {
								scope.courseRawdata = res.data;
								scope.courseDataLoaded = true;
								scope.courseInit = true;
								scope.courseData = scope.courseRawdata.response_data;
								scope.courseJson = JSON.stringify(scope.courseRawdata.response_data, null, 4)


							}
						).catch(function (err) {
							console.log(err.data);
							if (err.data.error) {
								scope.courseRawdata = err;
								scope.courseDataLoaded = true;

							} else {
								scope.courseDataLoadError = true;
							}

						})
					}
					scope.loadData();

					scope.dateParse = function (date) {

						let ret = ''
						if (typeof (date) == 'number') {
							ret = new Date(date);

						}
						return ret.toString();
					}

					scope.initCourse = function (useTemplate) {

						var coursedata = {};
						if (useTemplate) {
							coursedata = JSON.parse(JSON.stringify(selfStudyTemplate));
						}
						scope.saveCourse(coursedata);
					}

					scope.saveCourse = function (courseSpec) {
						try {
							var coursedata = {};
							if (typeof(courseSpec) == 'string') {
								coursedata = JSON.parse(courseSpec)
							}else if (typeof(courseSpec) == 'object'){
								coursedata = courseSpec;
							} else  {
								alert('could not save course');
								return;
							}
							$http.post(apiBase + '/course/', {
								course_id: scope.classid,
								course_data: coursedata

							}).then(function (res) {
								console.log(res);
								scope.loadData();
								alert('course saved');

							}).catch(function (err) {
								console.log(err);
								scope.parseErrors = err.data.parseErrors;
								alert(err.data.error);

							})
						} catch (e) {
							alert('could not save course');

						}

					}

					scope.changeJson = function (update) {
						try {
							var parsed = JSON.parse(update);
							scope.jsonValid = true;
							scope.courseJson = update;
						} catch (e) {
							scope.jsonValid = false;

						}

					}

					scope.handleUpdateTake = function(pid, optype) {
						if(isNaN(pid)){
							alert('could not update take');
							return;
						}

						switch(optype) {
							case 'r':
							default:
								scope.confirmMatch = 'Update course ' + scope.classid + ' version for participant ' + pid;
								scope.confirmPartId = pid;
								if(!scope.displayConfirm) scope.displayConfirm = true;
								scope.confirmDefferedFunc = reversionTake;
								break;
						}
					}

					scope.handleAwardCert = function(partId){
						if(isNaN(partId)){
							alert('could not award cert');
							return;
						}

						$http.post(apiBase + '/certificate/', {
							course_id: scope.classid,
							participant_id: partId

						}).then(function(res){
							scope.loadData();

						}).catch(function (err) {
							console.log(err.data);
							if (err.data.error) {
								alert(err.data.error);
							} else {
								alert('could not award cert');
							}
							scope.loadData();
						});
					}

					scope.handleRemoveTake = function(partId) {
						if(isNaN(partId)){
							alert('could not remove take');
							return;
						}

						scope.confirmPartId = partId;
						scope.confirmMatch = 'mult';
						if(!scope.displayConfirm) scope.displayConfirm = true;
						scope.confirmDefferedFunc = removeTake;
					}

					function reversionTake() {
						console.log('reversion!');
						$http.post(apiBase + '/take/update/', {
							optype: 'r',
							course_id: scope.classid,
							participant_id: scope.confirmPartId
						})
						.then(function (res) {
							console.log(res.data);
							scope.loadData();
							alert('take course version updated to version: ' + res.data.response_data.course_data.version);
						})
						.catch(function (err) {
							console.error(err.message);
							alert('could not update version');
						});
					}

					function removeTake() {
						console.log('remove take called');
						$http.post(apiBase + '/take/remove/', {
							course_id: scope.classid,
							participant_id: scope.confirmPartId
						})
						.then(function(res) {
							console.log(res.data);
							scope.loadData();
							alert('removed take for participant: ' + scope.confirmPartId);
						})
						.catch(function (err) {
							console.error(err.message);
							alert('could not remove take');
						});
					}

					scope.handleConfirm = function(confirmed, digest) {
						scope.displayConfirm = false;
						if (digest) scope.$digest();
						scope.confirmed = confirmed;
					};

					scope.toggleExpand = function(toggleItem) {
						scope[toggleItem] = !scope[toggleItem];
					}

					scope.$watch('courseJson', function (newValue, _, $scope) {
						if (newValue) {
							try {
								var parsed = JSON.parse(newValue);
								$scope.jsonValid = true;
							} catch (e) {
								$scope.jsonValid = false;

							}
						}
					}, true);

					scope.$watch('confirmed', function(newValue, _, $scope) {
						if (newValue && typeof $scope.confirmDefferedFunc == 'function') {
							$scope.confirmDefferedFunc();
							$scope.confirmDefferedFunc = null;
						} 
					});
				}
			}
		};
	}]);

	angular.module('vinAngularApp').directive('ceAdminConfirm', [function(){
		return {
			transclude: {
				message: '?confirmMessage',
				accept: '?acceptText',
				cancel: '?cancelText',
				title: '?confirmTitle'
			},
			restrict: 'AE',
			scope: {
				match: '@?',
				labelledby: '@',
				overlay: '@',
				result: '&onConfirm'
			},
			templateUrl: '/Global/JS/angular/vin.ce.admin.confirm.template.html',
			link: {
				pre: function(scope) {
					scope.overLayElem = document.querySelector(scope.overlay);
					if (scope.overLayElem) scope.overLayElem.classList.add('overlayed');
				},
				post: function(scope, elem) {
					var matchType = scope.match && scope.match.match(/mult/) ? 2 : 1;
					if (matchType === 2) {
						// from https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/random
						function getRandomInt(min, max) {
							min = Math.ceil(min);
							max = Math.floor(max);
							return Math.floor(Math.random() * (max - min)) + min; // The maximum is exclusive and the minimum is inclusive
						}

						var randNum1 = getRandomInt(100, 1000);
						var randNum2 = getRandomInt(100, 1000);
					}
					var matchTest = matchType ? matchType === 1 ? new RegExp(scope.match) : randNum1 * randNum2 : null;
					var matchElem = scope.match ? elem[0].querySelector('.match input') : null;
					var acceptButton = elem[0].querySelector('.accept');
					var cancelButton = elem[0].querySelector('.cancel');
					scope.matchText = scope.match && matchType === 1 ? scope.match : 'Multiply: ' + randNum1 + ' × ' + randNum2 + ', and input the result.'; 
					scope.showAccept = scope.match ? false : true;
					scope.matchInput = '';
					scope.validated = false;
					scope.displayInvalid = false;
					scope.confirmed = function(res, digest) {
						document.removeEventListener('focus', trapFocus);
						document.removeEventListener('keydown', scope.handleKeyDown);
						if (scope.overlayElem) scope.overLayElem.classList.remove('overlayed');
						scope.result({confirmed: res, digest: digest});
					};
					scope.accept = function(evt, digest) {
						if (evt) evt.preventDefault();
						scope.confirmed(true, digest);
					};
					scope.cancel = function(evt, digest) {
						if (evt) evt.preventDefault();
						scope.confirmed(false, digest);
					}
					scope.validate = function(update) {
						scope.validated = matchType === 1 ? update.match(matchTest) : parseInt(update) === matchTest;
					}
					scope.handleKeyDown = function(evt) {
						switch (evt.key) {
							case 'Escape':
								scope.cancel(null, true);
								break;
							case 'Enter':
								handleEnterKeyPress(evt);
								break;
							default:
								break;
						} 
					}
					scope.handleBlur = function(evt) {
						evt.target.classList.remove('focus');
					}

					function handleEnterKeyPress(evt) {
						evt.preventDefault();
						if (scope.match && scope.validated) {
							scope.accept(null, true);
							return;
						}
						if (scope.match && !scope.validated) {
							scope.displayInvalid = true;
							scope.$digest();
							try {
								matchElem.focus();
							} catch (error) {
								matchElem.classList.add('focus');
							}
							return;
						}
						if (document.activeElement === acceptButton || acceptButton.classList.contains('focus')) {
							scope.accept(null, true);
							return;
						}
						if (document.activeElement === cancelButton || cancelButton.classList.contains('focus')) {
							scope.cancel(null, true);
							return;
						}
					}

					function trapFocus(evt) {
						var focusElem = matchElem || acceptButton;
						if (focusElem) {
							try {
								focusElem.focus();
							} catch (error) {
								focusElem.classList.add('focus');
							}
						}
					};

					document.addEventListener('focus', trapFocus);
					document.addEventListener('keydown', scope.handleKeyDown);
					trapFocus(null);

					scope.$watch('validated', function (newValue, _, $scope) {
						if (newValue) {
							$scope.displayInvalid = false;
							$scope.showAccept = true;
						}
						else {
							if ($scope.showAccept) $scope.showAccept = false;
						}
					});
				}
			}
		};
	}]);

	angular.module('vinAngularApp').directive('ceSsParticipantList', [function() {
		return {
			restrict: 'AE',
			scope: {
				participantData: '<',
				participantNameData: '<',
				onAwardCert: '&',
				onRemoveTake: '&',
				onUpdateTake: '&'
			},
			templateUrl: '/Global/JS/angular/vin.ce.admin.selfstudy.participantList.template.html',
			link: {
				post: function(scope) {
					scope.awardCert = function(id) {
						scope.onAwardCert({id:id})
					};
					scope.removeTake = function(id) {
						scope.onRemoveTake({id:id})
					};
					scope.updateTake = function(id, optype) {
						scope.onUpdateTake({id:id, optype:optype})
					};
				}
			}
		};
	}]);

	angular.module('vinAngularApp').controller('rtsVinCeZoomWebinarLoader', ['$scope', '$http', '$interval', function ($scope, $http, $interval) {
		$scope.words = 'some words';

		$scope.updateWebinarList = function () {
			$scope.dts = new Date();
			$http.get('/a/z/v1/getclassrts', {
				params: {
					classid: $scope.classid,
					rnd: $scope.dts
				}
			}).then(function (res) {
				$scope.upRts = res.data;
			})
		}



		$scope.dtf = function (ds) {
			var retDate = new Date(ds);
			return retDate.toLocaleString();
		}

		$scope.editUrl = function (rts) {
			return 'https://www.zoom.us/webinar/' + rts.MeetingID;
		}

		$scope.enterSlideshowIdClick = function (rtsSession) {
			console.log(rtsSession);
			rtsSession.showInput = true;
		}

		$scope.saveSlideshowIdClick = function (rtsSession) {
			$http.post('/a/z/v1/setclassrtsslideshowid', {
				rtsid: rtsSession.RtsID,
				slideshowid: rtsSession.slideshowid
			}).then(function (res) {
				// $scope.upRts = res.data;
				console.log(res.data);
				if (res.data.length > 0 && res.data[0].hasOwnProperty('error')) {
					alert(res.data[0].error);
				} else {
					$scope.updateWebinarList();

				}
			});
		};

		$scope.processMiscSlides = function (rtsSession) {
			console.log(rtsSession);
			if (parseInt(rtsSession.selectMisc) > 0) {
				$http.post('/a/z/v1/processmisctranscript', {
					rtsid: rtsSession.RtsID,
					miscid: rtsSession.selectMisc,
					slideshowid: rtsSession.slideshowid
				}).then(function (res) {
					// $scope.upRts = res.data;
					console.log(res.data);
					if (res.data.hasOwnProperty('error')) {
						alert(res.data[0].error);
					} else if (res.data.hasOwnProperty('message')) {
						//$scope.updateWebinarList();
						alert(res.data.message);

					}
				});
			}
		}

		$scope.validateSlideshowId = function (rtsSession) {
			if (typeof rtsSession.slideshowid != 'number') rtsSession.slideshowid = 0;
			rtsSession.slideshowid = Math.round(rtsSession.slideshowid);
			rtsSession.slideshowid = Math.abs(rtsSession.slideshowid);

			console.log(rtsSession.slideshowid);
		}

		$scope.preventSubmit = function ($event, rtsSession) {
			if ($event.keyCode == 13) {
				$event.preventDefault();
				$scope.saveSlideshowIdClick(rtsSession);
			}
		}

		$scope.updateWebinarList();

	}])


	var selfStudyTemplate = {
		"title": "Template",
		"description": "This is a template",
		"style_brand": "vin",
		"version": 1,
		"module_order": [1000, 2000, 3000],
		"modules": {

			"1000": {
				"title": "Module 1",
				"total_duration": 4192,
				"type": "segments",
				"segment_order": [101, 102, 103, 104]
			},
			"2000": {
				"title": "Module 2",
				"total_duration": 2172,
				"type": "optional",
				"segment_order": [201, 202, 203]
			},
			"3000": {
				"title": "End of Course test",
				"total_duration": 120,
				"type": "test",
				"prerequisite": {
					"modules": [1000, 2000],
					"segments": []
				},
				"segment_order": [301]
			}
		},
		"segments": {
			"101": {
				"title": "Segment 1",
				"type": "video",
				"duration": 1011,
				"document_id": 9876,
				"url": "./media/m1s1.mp4",
				"thumbnail": "./media/m1s1.jpg"
			},
			"102": {
				"title": "Segment 2",
				"type": "video",
				"duration": 606,
				"document_id": 9876,
				"url": "./media/m1s2.mp4",
				"thumbnail": "./media/m1s2.jpg"
			},
			"103": {
				"title": "Polls 1-3",
				"type": "poll",
				"duration": 60,
				"questions": [{
					"q": "Module 1 - Poll 01: Which breed is known for very high egg production?",
					"ordinal": 1,
					"correct_answers": [3],
					"randomize": false,
					"answers": [{
							"a": "Plymouth Rock",
							"ordinal": 1,
							"response": "Nope, try again."
						},
						{
							"a": "Jersey Giant",
							"ordinal": 2,
							"response": "Nope, try again."
						}, {
							"a": "White Leghorn",
							"ordinal": 3,
							"response": "Correct! Congratulations!"
						}, {
							"a": "Silkie",
							"ordinal": 4,
							"response": "Nope, try again."
						}
					]
				}, {
					"q": "Module 1 - Poll 02: Which of the following terms indicates a female bird?",
					"ordinal": 2,
					"correct_answers": [2],
					"randomize": false,
					"answers": [{
							"a": "Cockerel",
							"ordinal": 1,
							"response": "Nope, try again."
						},
						{
							"a": "Pullet",
							"ordinal": 2,
							"response": "Correct! Congratulations!"
						}, {
							"a": "White Leghorn",
							"ordinal": 3,
							"response": "Nope, try again."
						}, {
							"a": "Silkie",
							"ordinal": 4,
							"response": "Nope, try again."
						}
					]
				}, {
					"q": "Module 1 - Poll 03: Which term is NOT associated with the leg?",
					"ordinal": 3,
					"correct_answers": [4],
					"randomize": false,
					"answers": [{
							"a": "Femur",
							"ordinal": 1,
							"response": "Nope, try again."
						},
						{
							"a": "Digit",
							"ordinal": 2,
							"response": "Nope, try again."
						}, {
							"a": "Spur",
							"ordinal": 3,
							"response": "Nope, try again."
						}, {
							"a": "Keel",
							"ordinal": 4,
							"response": "Correct! Congratulations!"
						}
					]
				}]
			},
			"104": {
				"title": "Assignment 1",
				"type": "text",
				"duration": 335,
				"url": "",
				"text": "<p style=\"font-size: inherit;\"><strong style=\"font-size: inherit;\">Module 1 Assignment</strong></p><p style=\"font-size: inherit;\">In addition to the learning modules (and their supporting supplemental materials), you will find the following:</p><ul style=\"font-size: inherit;\"><li style=\"font-size: inherit;\"><strong style=\"font-size: inherit;\">Additional Resources</strong> - These are items that the instructor thought the participants would find informative but which are not required as part of the course curriculum.</li><li style=\"font-size: inherit;\"><strong style=\"font-size: inherit;\">Module Transcripts</strong> - This category contains text transcripts and PPT handouts for each module, in case the participant would like to review the module content in a text format.</li></ul><p style=\"font-size: inherit;\"></p><p style=\"font-size: inherit;\"><strong style=\"font-size: inherit;\">Module 1 Supplemental Materials</strong></p><p style=\"font-size: inherit;\">Please attempt the following learning activities to help you remember some of the terminology and anatomy covered in module 1. Each link will open a new browser window/tab, so that when you are finished with the activity, you will need to close that browser window/tab to return here.&nbsp; These items can also be found in the course library under Library &gt; Module 1 &gt; Supplemental Materials.</p><ul style=\"font-size: inherit;\"><li style=\"font-size: inherit;\"><a href=\"/doc/?id=8502299&amp;pid=20743\" target=\"_blank\" style=\"font-size: inherit;\">Poultry Terminology Crossword Puzzle</a></li><li style=\"font-size: inherit;\"><a href=\"/members/cms/project/defaultadv1.aspx?pid=10902&amp;game=rooster\" target=\"_blank\" style=\"font-size: inherit;\">Rooster Drag-n-Drop</a></li><li style=\"font-size: inherit;\"><a href=\"/members/cms/project/defaultadv1.aspx?pid=10902&amp;game=chicken\" target=\"_blank\" style=\"font-size: inherit;\">Chicken Internal Anatomy Drag-n-Drop</a></li><li style=\"font-size: inherit;\"><a href=\"/members/cms/project/defaultadv1.aspx?pid=10902&amp;game=chickenresp\" target=\"_blank\" style=\"font-size: inherit;\">Chicken Respiratory System Drag-n-Drop </a></li></ul><p style=\"font-size: inherit;\"></p><p style=\"font-size: inherit;\">Once you have completed the supplemental materials, please close this window, return to the course library and start module 2.</p><p style=\"font-size: inherit;\"></p><p style=\"font-size: inherit;\"></p><p style=\"font-size: inherit;\"></p>"
			},
			"201": {
				"title": "Segment 1",
				"type": "video",
				"duration": 317,
				"document_id": 9876,
				"url": "./media/m2s1.mp4",
				"thumbnail": "./media/m2s1.jpg"
			},
			"202": {
				"title": "Polls 1-2",
				"type": "poll",
				"duration": 60,
				"questions": [{
					"q": "Module 2 - Poll 01: When holding a bird, it is important to:",
					"ordinal": 1,
					"correct_answers": [3],
					"randomize": false,
					"answers": [{
							"a": "Hold by one leg only",
							"ordinal": 1,
							"response": "Nope, try again."
						},
						{
							"a": "Hold heavy birds by one wing",
							"ordinal": 2,
							"response": "Nope, try again."
						}, {
							"a": "Ensure bird is not held too tightly",
							"ordinal": 3,
							"response": "Correct! Congratulations!"
						}, {
							"a": "Let the bird scratch your arms",
							"ordinal": 4,
							"response": "Nope, try again."
						}
					]
				}, {
					"q": "Module 2 - Poll 02: When holding a large bird, such as a duck or goose, you should NOT:",
					"ordinal": 2,
					"correct_answers": [4],
					"randomize": false,
					"answers": [{
							"a": "Place it on the ground",
							"ordinal": 1,
							"response": "Nope, try again."
						},
						{
							"a": "Place a towel or blanket over it's wings",
							"ordinal": 2,
							"response": "Nope, try again."
						}, {
							"a": "Trap it's head under your elbow",
							"ordinal": 3,
							"response": "Nope, try again."
						}, {
							"a": "Hold is upside-down by one leg",
							"ordinal": 4,
							"response": "Correct! Congratulations!"
						}
					]
				}]
			},
			"203": {
				"title": "Polls 3-4",
				"type": "poll",
				"duration": 60,
				"questions": [{
					"q": "Module 2 - Poll 03: The first step in the clinical physical exam is:",
					"ordinal": 1,
					"correct_answers": [1],
					"randomize": false,
					"answers": [{
							"a": "Observation of the bird",
							"ordinal": 1,
							"response": "Correct! Congratulations!"
						},
						{
							"a": "Cardiac auscultation",
							"ordinal": 2,
							"response": "Nope, try again."
						}, {
							"a": "Cloacal exam",
							"ordinal": 3,
							"response": "Nope, try again."
						}, {
							"a": "Examination of the oral cavity",
							"ordinal": 4,
							"response": "Nope, try again."
						}
					]
				}, {
					"q": "Module 2 - Poll 04: If you find a bird has swollen feet, which of the following would not be a likely rule-out?",
					"ordinal": 2,
					"correct_answers": [3],
					"randomize": false,
					"answers": [{
							"a": "Gout",
							"ordinal": 1,
							"response": "Nope, try again."
						},
						{
							"a": "Staphylococcus arthritis",
							"ordinal": 2,
							"response": "Nope, try again."
						}, {
							"a": "Coccidiosis",
							"ordinal": 3,
							"response": "Correct! Congratulations!"
						}, {
							"a": "Knemidokoptiasis",
							"ordinal": 4,
							"response": "Nope, try again."
						}
					]
				}]
			},
			"301": {
				"title": "End of course test",
				"type": "poll",
				"duration": 60,
				"questions": [{
					"q": "True or False? The term “pullet” refers to a young female chicken that has not yet begun laying eggs. ",
					"ordinal": 1,
					"correct_answers": [1],
					"randomize": false,
					"answers": [{
							"a": "True",
							"ordinal": 1,
							"response": "Correct! Congratulations!."
						},
						{
							"a": "False",
							"ordinal": 2,
							"response": "Nope, try again."
						}
					]
				}, {
					"q": "A Cornish hen is ",
					"ordinal": 2,
					"correct_answers": [1],
					"randomize": false,
					"answers": [{
							"a": "A broiler/fryer chicken raised to 3-4 wks old ",
							"ordinal": 1,
							"response": "Correct! Congratulations!"
						},
						{
							"a": "BA specific breed of poultry about the size of a quail ",
							"ordinal": 2,
							"response": "Nope, try again."
						}, {
							"a": " A type of pheasant ",
							"ordinal": 3,
							"response": "Nope, try again."
						}, {
							"a": "A hen raised on corn ",
							"ordinal": 4,
							"response": "Nope, try again."
						}
					]
				}]
			}
		},
		"documents": []

	}


})()

vinAngular.directive('ngVinResize', ['$interval', function ($interval) {



	return {
		scope: {
			boxScale: '@',
			boxOpacity: '@',
			boxLeftMargin: '@',
			boxTopMargin: '@'
		},
		restrict: 'A',
		transclude: true,
		replace: true,
		templateUrl: '/Global/JS/angular/vin.resizeBox.template.html',
		link: function (scope, element, attr) {
			scope.boxScale = 0.001;
			scope.boxOpacity = 1;
			scope.boxLeftMargin = 0;
			scope.boxTopMargin = 0;
			scope.lastParentWidth = 0;
			scope.lastParentHeight = 0;
			scope.classTime = 100;

			function resizeBox() {

				var boxWidth = element[0].offsetWidth;
				var boxHeight = element[0].offsetHeight;
				var boxRatio = boxWidth / boxHeight;
				var parentWidth = element.parent()[0].offsetWidth;
				var parentHeight = element.parent()[0].offsetHeight;
				var parentRatio = parentWidth / parentHeight;

				scope.boxOpacity = 0;
				scope.boxScale = 1;
				var scale = 1;
				if (boxRatio > parentRatio) {
					scale = parentWidth / boxWidth;
					scope.boxLeftMargin = 0;
					scope.boxTopMargin = parseInt((parentHeight - (boxHeight * scale)) / 2);
				} else {
					scale = parentHeight / boxHeight;
					scope.boxLeftMargin = parseInt((parentWidth - (boxWidth * scale)) / 2);
					scope.boxTopMargin = 0;
				}
				scope.boxScale = scale;
				scope.boxOpacity = 1;


			};
			scope.resizeInterval = $interval(resizeBox, 150);

		}
	};

}]);





/*
vinAngular.controller("resizeBox",function($scope, $element){
	
	$scope.boxScale = 1;
	$scope.boxOpacity = 1 ;
	$scope.boxLeftMargin= 0 ;
	$scope.boxTopMargin= 0 ;
	
	$scope.resize = function(){
		$scope.boxOpacity = 0;
		$scope.boxScale = 1;
		var boxWidth = $element[0].offsetWidth;
		var boxHeight = $element[0].offsetHeight;
		var boxRatio = boxWidth/boxHeight;
		var parentWidth = $element.parent().parent()[0].offsetWidth;
		var parentHeight = $element.parent().parent()[0].offsetHeight;
		var parentRatio = parentWidth/parentHeight;
		var scale = 1;
		if(boxRatio>parentRatio){
			scale = parentWidth / boxWidth;
			$scope.boxLeftMargin= 0 ;
			$scope.boxTopMargin= parseInt(( parentHeight-(boxHeight*scale) )/2)  ;
		}else{
			scale = parentHeight / boxHeight;
			$scope.boxLeftMargin= parseInt(( parentWidth-(boxWidth*scale) )/2)  ;
			$scope.boxTopMargin= 0 ;
		}
		$scope.boxScale = scale;
		$scope.boxOpacity = 1;
	};
	
	
	$scope.resizeEvent = (function(that){
		return function(){
			that.resize();
		};
	})($scope);
	
	setInterval($scope.resizeEvent,500);
	window.addEventListener('resize', $scope.resizeEvent);
	$element.parent().parent()[0].addEventListener('resize', $scope.resizeEvent);
	
	
	
	
	$scope.resize();
	
});

*/