(function() {
    document.addEventListener('DOMContentLoaded', _ => {
        
        /*****
         * BEGIN CLEANUP
         *****/
        // find slideshow or Presenter divs
        let mediaDivs = document.querySelectorAll('.MediaContent[type="presenter"');
        mediaDivs.forEach(el => {
            let xmlPath = el.getAttribute('xmlpath');
            
            if(typeof xmlPath === 'string' && (xmlPath = xmlPath.toLowerCase()) && xmlPath.indexOf('projectid=') >= 0) {
                let projectId = xmlPath.match(/projectid=(\d+)/)[1];
                
                let slidePreviewDiv = document.createElement('div');
                slidePreviewDiv.setAttribute('class', 'slideshow-preview');
                slidePreviewDiv.dataset.projectId = projectId;
                el.parentNode.insertBefore(slidePreviewDiv, el);

                if(xmlPath.indexOf('initslide') >= 0) {
                    let initSlide = xmlPath.match(/initslide=(\d+)/)[1];
                    slidePreviewDiv.dataset.initSlide = initSlide;
                }
            }
            
            el.parentNode.removeChild(el);
            console.log('removing old style node');
        });

        // Clean up any Flash Embeding html
        document.querySelectorAll('.flash-embedding-link').forEach(el => el.remove());
        /*****
         * END CLEANUP
         *****/

        // (check for jQuery)
        let slideshowPreviews = $j('.slideshow-preview');

        slideshowPreviews.each(function(i) {
            buildCarousel($j(this), i);
        });
    });

    function buildCarousel(el, i) {
        el = $j(el);
        el.css('text-align', 'center');

        let slideshowDataUrl = '';
        let slideshowType = '';
        let slideshowId = 0;

        let documentId = parseInt(el.data('documentId'));
        let projectId = parseInt(el.data('projectId'));
        let threadId = parseInt(el.data('threadId'));

        if (!isNaN(documentId) && documentId > 0) {
            slideshowType = 'Document';
            slideshowId = documentId;
            slideshowDataUrl = `/a/p4/v1/getShow?documentId=${documentId}`;
        }
        else if(!isNaN(projectId) && projectId > 0) {
            slideshowType = 'Project';
            slideshowId = projectId;
            slideshowDataUrl = `/a/p4/v1/getshow?projectId=${projectId}`;
        }
        else if (!isNaN(threadId) && threadId  > 0) {
            slideshowType = 'Thread';
            slideshowId = threadId;
            slideshowDataUrl = `/a/p4/v1/getshow?threadId=${threadId}`
        }

        let carouselHeight = parseInt(el.attr('height'));
        if (isNaN(carouselHeight) || carouselHeight <= 0) {
            carouselHeight = 400;
        }

        let initSlide = parseInt(el.data('initSlide'));
        let showTitle = el.data('showTitle') !== false;
        let showNavigation = el.data('showNavigation') !== false;
        let allowPresenter = el.data('allowPresenter') !== false;

        if (slideshowDataUrl == '') {
            console.error('Slideshow preview failed. Missing Document ID, Project ID, or Thread ID.');
            logError('load', 'Missing Document ID, Project ID, or Thread ID.');
        }
        else {
            fetch(slideshowDataUrl)
                .then(response => response.json())
                .then(function(data) {
                    let slidesArray = [];
                    let nonViewableArray = [];
                    
                    for (let i = 0; i < data.slideshow.order.length; i++) {
                        let slide = data.slideshow.slides[data.slideshow.order[i]];
                        if (slide.filetypeid === 3 || slide.filetypeid === 4 || slide.filetypeid === 8) {
                            slidesArray.push(slide);
                        }
                        else {
                            nonViewableArray.push(slide);
                        }
                    }

                    if (showTitle) {
                        let titleDiv = $j('<div class="embedded-slideshow-title"></div>');
                        titleDiv.css({
                            fontWeight: 600,
                            fontSize: '16px',
                            padding: '25px 15px 0',
                            margin: 0
                        });
                        titleDiv.text(data.slideshow.title);
                        el.append(titleDiv);
                    }

                    if (showNavigation) {
                        $j(`<div class="ss-nav ss-prev btn btn-primary" data-target="#slide-preview-${i}" data-slide="prev">Previous</div>`).appendTo(el);
                        $j(`<div class="ss-nav position">Slide <span class="current-index">1</span> of ${slidesArray.length.toString()}</div>`).appendTo(el);
                        $j(`<div class="ss-nav ss-next btn btn-primary" data-target="#slide-preview-${i}" data-slide="next">Next</div>`).appendTo(el);

                        $j('.ss-nav').css('display', 'inline-block').css('margin', '10px');
                    }

                    let slideContainer = $j(`<div class="carousel"/>`);
                    slideContainer.attr('id', `slide-preview-${i}`);
                    slideContainer.css({
                        padding: '0 20px 20px'
                    });

                    if (showNavigation) {
                        slideContainer.data('interval', false);
                        slideContainer.data('wrap', false);
                    }
                    slideContainer.height(carouselHeight);

                    let stage = $j('<div class="stage carousel-inner"/>').appendTo(slideContainer);

                    slidesArray.forEach(element => {
                        let carouselItem = $j('<div class="item"></div>');
                        if (element.filetypeid === 4 || element.filetypeid === 3) {
                            let img = $j('<img class="d-block w-100"/>');
                            img.attr('src', element.url);
                            img.css({
                                maxHeight: carouselHeight,
                                maxWidth: '100%',
                                height: carouselHeight,
                                display: 'inline'
                            });
                            carouselItem.append(img);
                        }
                        else if (element.filetypeid === 8) {
                            let video = $j(`<video controls class="h-100 w-100 video-js" type="video/mp4"></video>`);
                            video.attr('height', carouselHeight);
                            video.contextmenu(function(e){e.preventDefault;return false});

                            let src = $j('<source type="video/mp4"></source>');
                            src.attr('src', `/c/video/${element.documentid}`);
                            src.appendTo(video);

                            carouselItem.append(video);
                        }
                        stage.append(carouselItem);
                    });

                    if(!isNaN(initSlide) && initSlide > 0) {
                        console.log(`Showing Slide #${initSlide}`);
                        $j(`.item:eq(${initSlide - 1})`, stage).addClass('active');
                        $j('.position .current-index', el).text(initSlide.toString());
                    }
                    else {
                        console.log('Showing First Slide.');
                        $j('.item', stage).first().addClass('active');
                    }

                    el.append(slideContainer);

                    if (allowPresenter) {
                        let presenterButton = $j('<span class="btn btn-primary"/>');
                        presenterButton.text('Open in Presenter');
                        presenterButton.css('margin', '10px');
                        presenterButton.on('click', _ => { 
                            logSlideshowEvent({
                                event_type: 'openPresenter',
                                slideshow_type: slideshowType,
                                slideshow_id: slideshowId
                            });
                            window.open(`/p4/p4.html?${slideshowType.toLowerCase()}id=${slideshowId}`);
                        });
                        el.append(presenterButton);
                    }

                    slideContainer.carousel();
                    slideContainer.on('slid.bs.carousel', function(event) {
                        let element = $j(event.currentTarget);
                        let index = element.find('.item.active').index() + 1;
                        $j('.position .current-index').text(index.toString());
                        logSlideshowEvent({
                            event_type: 'navigation',
                            slideshow_id: slideshowId,
                            slide_id: index
                        });
                    });

                    logSlideshowEvent({
                        event_type: 'load',
                        slideshow_type: slideshowType,
                        slideshow_id: slideshowId
                    });
                })
                .catch(error => {
                    console.error('slideshow preview error', error);
                    logError('load', error);
                });
        }
    }

    function logSlideshowEvent(action) {
        action.application = 'SlideshowPreview';
        fetch('/a/l/logevent', {
            method: 'POST',
            headers: {
                'Accept': 'application/json',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ action: action })
        });
    }

    function logError(errorType, errorMessage) {
        let action = {
            event_type: 'error',
            error_type: errorType,
            error_message: errorMessage
        };
        logSlideshowEvent(action);
    }
})();