function resourceSearch(path) 
{
	if (path == "/")
		path = "";

	window.location = path + '/Resources/SubTopic.aspx?search=' + escape(document.getElementById('resourcesearchtext').value);
}

function doSearchEnterKey(e, path) 
{
	if (window.event) // IE
	{
		keynum = e.keyCode;
	}
	else if (e.which) // Netscape/Firefox/Opera
	{
		keynum = e.which;
	}

	if (keynum == "13") {
		resourceSearch(path);
		return false;
	}
}

//#OS# appends or replaces the specified parameter and returns the resulting query string
function setQueryStringParameter(queryString, parameterName, parameterValue) {

	if (queryString.indexOf(parameterName) > 0) {
		var re = new RegExp(parameterName + '=\\S+&', 'g');

		if (queryString.match(re)) {
			queryString = queryString.replace(re, parameterName + '=' + parameterValue + '&');
		}
		else {
			var re = new RegExp(parameterName + '=\\S+', 'g');

			queryString = queryString.replace(re, parameterName + '=' + parameterValue);
		}
	}
	else {
		var t = '?';
		if (queryString.indexOf('?') > 0)
			t = '&';

		queryString = queryString + t + parameterName + '=' + parameterValue;
	}

	return queryString;
}

function getQueryStringParameterByName(queryString, parameterName) {
	parameterName = parameterName.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
	var regexS = "[\\?&]" + parameterName + "=([^&#]*)";
	var regex = new RegExp(regexS);
	var results = regex.exec(queryString);
	if (results == null)
		return "";
	else
		return decodeURIComponent(results[1].replace(/\+/g, " "));
}