function TurnSpotlightOn(event) {
	//First get the 'thing' that was clicked.
	var linkHandle = Event.element(event);

	//Remember the parent of the thing that was clicked
	var spotlightContentLocation = linkHandle.up(".spotlight_this");

	var SpotlightControl = $('SpotlightControl');

	//Get the content to be spotlit
	var spotlightContent = spotlightContentLocation.down(".spotlight_content");

	var html;
	var width;
	var height;

	//If it's a movie, just load the movie string. Else, grab the content that hidden on the page.
	if (spotlightContent.hasClassName("run_demo_movie")) {
		html = getMovieAsHTMLString('/tutorcom-overview.swf?spak=sv', 510, 355);
		width = 515;
		height = 360;
	}
	else if (spotlightContent.hasClassName("run_cmt_movie")) {
		html = getMovieAsHTMLString('/tutorcom-overview-cmt.swf?spak=sv', 510, 355);
		width = 515;
		height = 360;
	}
	else if (spotlightContent.hasClassName("run_new_video")) {
		html = getMovieAsHTMLString('/new-video.swf?spak=sv', 510, 340);
		width = 515;
		height = 345;
	}
	else if (spotlightContent.hasClassName("run_slideshow")) {
		html = getMovieAsHTMLString('/slideshow.swf?spak=sv', 510, 355);
		width = 515;
		height = 360;
	}
	else if (spotlightContent.hasClassName("run_resume_video")) {
		html = getMovieAsHTMLString('/media/resume-workshop.swf?spak=sv', 740, 518);
		width = 750;
		height = 525;
	}
	else if (spotlightContent.hasClassName("run_library_video")) {
		html = getMovieAsHTMLString('/lhhv4-sales-tour.swf', 800, 580);
		width = 815;
		height = 600;
	}
	else if (spotlightContent.hasClassName("run_career_center_video")) {
		html = getMovieAsHTMLString('/CareerCenterOffer/career-center-video.swf', 740, 518);
		width = 750;
		height = 525;
	}
	else {
		//Inject the content into the spotlight
		html = spotlightContent.innerHTML;
		width = 550;
		height = 400;
	}

	width += 25;
	height += 50;

	SpotlightElement(linkHandle.up(".spotlight_this").title, null, width, height, html);
}

function SpotlightElement(title, moviePath, width, height, html, onCloseTopUrl, isNotCloseable) {

	if (typeof isNotCloseable == 'undefined' || isNotCloseable == null || !isNotCloseable)
		isNotCloseable = false;

	var movieWidth = width;
	var movieHeight = height;

	if (typeof width == 'undefined' || width == null || !width) {
		movieWidth = 510;
		width = 540;
	}

	if (typeof height == 'undefined' || height == null || !height) {
		movieHeight = 355;
		height = 410;
	}
	else if (height > 650) {
		var factor = 650 / height;

		width *= factor;
		movieWidth *= factor;
		height *= factor;
		movieHeight *= factor;
	}

	if (typeof moviePath != 'undefined' && moviePath != null) {
		html = getMovieAsHTMLString(moviePath, movieWidth, movieHeight);
		width += 35;
		height += 50;
	}
	else if (typeof html != 'undefined' && html != null) {
		//nothing to do
	}

	jQuery('#SpotlightControl_JQuery').html(html);

	jQuery('#SpotlightControl_JQuery').dialog({
		autoOpen: false,
		draggable: false,
		closeText: (isNotCloseable) ? '' : 'Close Window [X]',
		resizable: false,
		modal: true,
		beforeclose: function(event, ui) {
			jQuery('#SpotlightControl_JQuery').html('');
			if (typeof onCloseTopUrl != 'undefined' && onCloseTopUrl != null) {
				top.location = onCloseTopUrl;
			}
		},
		closeOnEscape: !isNotCloseable
	});

	//reset title, width, etc.
	jQuery('#SpotlightControl_JQuery').dialog('option', 'title', title);
	jQuery('#SpotlightControl_JQuery').dialog('option', 'width', width);
	jQuery('#SpotlightControl_JQuery').dialog('option', 'height', height + 15);

	jQuery('#SpotlightControl_JQuery').dialog('open');

	if (isNotCloseable)
		jQuery('.ui-dialog-titlebar-close').hide();
	else
		jQuery('.ui-dialog-titlebar-close').show();

	//log in analytics
	if (typeof (Analytics_TrackPage) != 'undefined') {
		var track;

		if (typeof moviePath != 'undefined' && moviePath != null)
			track = moviePath;
		else
			track = '/' + title;

		Analytics_TrackPage('/spotlight' + track);
	}
}

function getMovieAsHTMLString(video_path, video_width, video_height) {
	return '<object type="application/x-shockwave-flash" data="' + video_path + '" width="' + video_width + '" height="' + video_height + '">' +
		 '<param name="movie" value="' + video_path + '">' +
		 '<param name="bgcolor" value="#FFFFFF">' +
		 '<param name="menu" value="false">' +
		 '<param name="quality" value="high">' +
		  '<h3>Missing Adobe Flash</h3>' +
		  '<br>You must have the Adobe Flash browser plug-in to view this item. <a href="http://www.macromedia.com/go/getflashplayer" target="_blank" style="text-decoration:underline;">Click here to install the Adobe Flash plugin</a> now.' +
		'</object>';
}

function TurnSpotlightOff(event) {
	jQuery('#SpotlightControl_JQuery').dialog('close');
}

var SPOTLIGHT_LOADED = false; //global var to track spotlight loaded status

jQuery(function () {
	if (typeof Event != 'undefined' && typeof Event.observe != 'undefined') {
		var spotlights_on = $$('div.spotlight_display_object');
		//if there are no on switches, then there's no point in doing anything else

		if (spotlights_on.length > 0) {
			for (var index = 0; index < spotlights_on.length; index++) {
				Event.observe(spotlights_on[index], 'click', TurnSpotlightOn);
				Event.observe(spotlights_on[index], 'spotlight:show', TurnSpotlightOn);

				//There's 2 types of additional
				//calls we want to make depending on if a homepage video or a secondary video was clicked.
				if (spotlights_on[index].up("#DemoVideo.homepage")) {
					Event.observe(spotlights_on[index], 'click', function () {
						Analytics_TrackPage("session-demo.html?event=HomepageVideo-Clicked", '/session-demo.html?event=HomepageVideo-Clicked');
					});
				}
				else {
					Event.observe(spotlights_on[index], 'click', function () {
						Analytics_TrackPage("session-demo.html?event=SecondaryPageVideo-Clicked", '/session-demo.html?event=SecondaryPageVideo-Clicked');
					});
				}

			}
		}
	}
});

SPOTLIGHT_LOADED = true;