(function (funcName, baseObj) {
    "use strict";
    // https://github.com/jfriend00/docReady
    // The public function name defaults to window.docReady
    // but you can modify the last line of this function to pass in a different object or method name
    // if you want to put them in a different namespace and those will be used instead of
    // window.docReady(...)
    funcName = funcName || "docReady";
    baseObj = baseObj || window;
    var readyList = [];
    var readyFired = false;
    var readyEventHandlersInstalled = false;

    // call this when the document is ready
    // this function protects itself against being called more than once
    function ready() {
        if (!readyFired) {
            // this must be set to true before we start calling callbacks
            readyFired = true;
            for (var i = 0; i < readyList.length; i++) {
                // if a callback here happens to add new ready handlers,
                // the docReady() function will see that it already fired
                // and will schedule the callback to run right after
                // this event loop finishes so all handlers will still execute
                // in order and no new ones will be added to the readyList
                // while we are processing the list
                readyList[i].fn.call(window, readyList[i].ctx);
            }
            // allow any closures held by these functions to free
            readyList = [];
        }
    }

    function readyStateChange() {
        if (document.readyState === "complete") {
            ready();
        }
    }

    // This is the one public interface
    // docReady(fn, context);
    // the context argument is optional - if present, it will be passed
    // as an argument to the callback
    baseObj[funcName] = function (callback, context) {
        if (typeof callback !== "function") {
            throw new TypeError("callback for docReady(fn) must be a function");
        }
        // if ready has already fired, then just schedule the callback
        // to fire asynchronously, but right away
        if (readyFired) {
            setTimeout(function () {
                callback(context);
            }, 1);
            return;
        } else {
            // add the function and context to the list
            readyList.push({ fn: callback, ctx: context });
        }
        // if document already ready to go, schedule the ready function to run
        // IE only safe when readyState is "complete", others safe when readyState is "interactive"
        if (document.readyState === "complete" || (!document.attachEvent && document.readyState === "interactive")) {
            setTimeout(ready, 1);
        } else if (!readyEventHandlersInstalled) {
            // otherwise if we don't have event handlers installed, install them
            if (document.addEventListener) {
                // first choice is DOMContentLoaded event
                document.addEventListener("DOMContentLoaded", ready, false);
                // backup is window load event
                window.addEventListener("load", ready, false);
            } else {
                // must be IE
                document.attachEvent("onreadystatechange", readyStateChange);
                window.attachEvent("onload", ready);
            }
            readyEventHandlersInstalled = true;
        }
    }
})("docReady", window._HB_);
// modify this previous line to pass in your own method name
// and object for the method to be attached to

(function () {
    "use strict";
    var hbNamespace = window._HB_;

    // global styles
    var hbContactFormIframeStyle = "";
    var hbLeadFormIframeStyle = "border-width: 0; box-shadow: 0px 1px 6px 0px rgba(0, 18, 71, 0.10), 0px 1px 3px 0px rgba(0, 18, 71, 0.10); border-radius: 4px; margin: 5% ";

    (function () {
        // https://tc39.github.io/ecma262/#sec-array.prototype.find
        if (!Array.prototype.find) {
            Object.defineProperty(Array.prototype, 'find', {
                value: function (predicate) {
                    // 1. Let O be ? ToObject(this value).
                    if (this == null) {
                        throw new TypeError('"this" is null or not defined');
                    }

                    var o = Object(this);

                    // 2. Let len be ? ToLength(? Get(O, "length")).
                    var len = o.length >>> 0;

                    // 3. If IsCallable(predicate) is false, throw a TypeError exception.
                    if (typeof predicate !== 'function') {
                        throw new TypeError('predicate must be a function');
                    }

                    // 4. If thisArg was supplied, let T be thisArg; else let T be undefined.
                    var thisArg = arguments[1];

                    // 5. Let k be 0.
                    var k = 0;

                    // 6. Repeat, while k < len
                    while (k < len) {
                        // a. Let Pk be ! ToString(k).
                        // b. Let kValue be ? Get(O, Pk).
                        // c. Let testResult be ToBoolean(? Call(predicate, T, « kValue, k, O »)).
                        // d. If testResult is true, return kValue.
                        var kValue = o[k];
                        if (predicate.call(thisArg, kValue, k, o)) {
                            return kValue;
                        }
                        // e. Increase k by 1.
                        k++;
                    }

                    // 7. Return undefined.
                    return undefined;
                },
                configurable: true,
                writable: true
            });
        }
    })();

    if (!hbNamespace.ctrlLoaded) {
        hbNamespace.basePath = 'https://widget.honeybook.com/assets_users_production/websiteplacements/';
        if (hbNamespace.placementBasePathOverride) {
            hbNamespace.basePath = hbNamespace.placementBasePathOverride;
        }

        hbNamespace.genericConfigFile = 'placement_generic_config.js';
        hbNamespace.genericConfigBasePath = hbNamespace.basePath;

        if (hbNamespace.genericConfigPathOverride) {
            hbNamespace.genericConfigBasePath = hbNamespace.genericConfigPathOverride;
        }

        hbNamespace.ctrlLoaded = true;

        hbNamespace._hb_jsonp_callback_generic_config = function (genericConfig) {
            hbNamespace.genericConfig = genericConfig;
            hbNamespace.runIfGotAllConfigurations();
            if (hbNamespace.isInPreviewMode()) {
                hbNamespace.generatePreviewMode();
            }
        };

        hbNamespace.generatePreviewMode = function () {
            var hbWrapper = document.getElementsByClassName(hbNamespace.runtimeConfig.contact_form_selector)[0];
            var iframeUrl = hbNamespace.genericConfig.contact_form.current_app_entry_point;// + '?contact_form_id=' + ;
            hbNamespace.createFormIframe('contact', hbWrapper, iframeUrl, 2, hbNamespace.runtimeConfig.contact_form_id, 750, '100%', hbContactFormIframeStyle);
        };

        hbNamespace._hb_jsonp_callback_user_config = function (userConfig) {
            hbNamespace.userConfig = userConfig;

            hbNamespace.runIfGotAllConfigurations();
        };

        // helpers
        hbNamespace.isInPreviewMode = function () {
            return hbNamespace.runtimeConfig && hbNamespace.runtimeConfig.is_preview;
        };

        hbNamespace.handleForms = function (userConfig) {
            userConfig.contact_forms.forEach(function (contactForm) {

                if (hbNamespace.iframeElements[contactForm._id]) {
                    hbNamespace.renderContactForm(contactForm, hbNamespace.userConfig.company, hbNamespace.userConfig, {});
                    return;
                }

                var hbWrapper = hbNamespace.getHbWrapperElement(userConfig, contactForm._id);
                if (!hbWrapper) {
                    // TODO: report ? log ? notify ?
                    return;
                }

                var iframeUrl = null;
                if (contactForm.version <= 1) {
                    iframeUrl = contactForm.url + '?';
                    iframeUrl += 'is_controller_hosted=1&placement_id=' + hbNamespace.pid +
                        '&placement_data_version=' + hbNamespace.userConfig.data_version +
                        '&placement_schema_version=' + hbNamespace.userConfig.schema_version +
                        '&contact_form_schema_version=' + contactForm.version;

                } else {
                    iframeUrl = hbNamespace.genericConfig.contact_form.current_app_entry_point;// + '?contact_form_id=' + contactForm._id; //+ '&user_config_path=' + hbNamespace.userConfigFilePath + '&';
                    if (hbNamespace.genericConfig.environment &&
                        hbNamespace.genericConfig.environment !== 'production') {
                        iframeUrl += '?env=' + hbNamespace.genericConfig.environment;
                    }
                }

                hbNamespace.createFormIframe('contact', hbWrapper, iframeUrl, contactForm.version, contactForm._id, 750, '100%', hbContactFormIframeStyle);
            });
            userConfig.lead_forms.forEach(function (leadForm) {
                var hbWrapper = hbNamespace.getHbWrapperElement(userConfig, leadForm._id);
                if (!hbWrapper) {
                    return;
                }
                var leadFormEmbedUrl = leadForm.url.replace("/public/", "/embed/");
                hbNamespace.createFormIframe('lead', hbWrapper, leadFormEmbedUrl, 1, leadForm._id, '90%', '90%', hbLeadFormIframeStyle);
            });
        };


        function objectShallowAssign(first, second) {
            Object.keys(second).forEach(function (key) {
                first[key] = second[key];
            });
        }

        window.onCompanyBrandingLoad = function (companyBrandingData) {
            hbNamespace.companyBrandingData = companyBrandingData;

            hbNamespace.runIfGotAllConfigurations();
        };

        hbNamespace.getHbWrapperElement = function (userConfig, formId) {
            var hbWrapper = null;
            var elements = null;

            var userSelectorConfig = userConfig.selectors[formId];

            if (userSelectorConfig === undefined) {
                return;
            }

            switch (userSelectorConfig.selector_type) {
                case "id":
                    hbWrapper = document.getElementById(userSelectorConfig.selector);
                    break;
                case "class":
                    elements = document.getElementsByClassName(userSelectorConfig.selector);
                    if (elements && elements.length > 0) {
                        hbWrapper = elements[0];
                    }
                    break;

                default:
            }

            return hbWrapper;
        };

        hbNamespace.loadScript = function loadScript(url, callback, async) {
            var hba = document.createElement("script");
            hba.type = "text/javascript";
            hba.async = typeof async === 'undefined' ? true : !!async;
            hba.src = url;
            hba.onload = function () {
                if (callback) {
                    callback();
                }
            };

            var hbe = document.getElementsByTagName("script")[0];
            hbe.parentNode.insertBefore(hba, hbe);

            return hba;
        };

        hbNamespace.createFormIframe = function createFormIframe(formType, hbWrapper, url, formSchemaVersion, formId, height, width, iframe_style) {
            var iframeElement = document.createElement('iframe');
            iframeElement.src = url;
            iframeElement.height = height;
            iframeElement.width = width;
            iframeElement.name = formId;
            iframeElement.frameBorder = 0;
            iframeElement.style = iframe_style;
            iframeElement.allow = "allow-top-navigation allow-top-navigation-by-user-activation";
            hbWrapper.appendChild(iframeElement);
            hbNamespace.iframeElements[formId] = iframeElement;
            if (formType === 'contact') {
                var iframeResizerUrl = formSchemaVersion == 2 ? 'https://d25purrcgqtc5w.cloudfront.net/assets/widgetiframe/iframeResizer_v4.min.js' : 'https://d25purrcgqtc5w.cloudfront.net/assets/widgetiframe/iframeResizer.min.js';
                hbNamespace.loadScript(iframeResizerUrl, hbNamespace.triggerIframeResize, false);
                hbNamespace.registerIntersectionObserver(formId, hbWrapper);
            }
        };

        hbNamespace.triggerIframeResize = function triggerIframeResize() {
            window.iFrameResize({ checkOrigin: false });
        };

        hbNamespace.runIfGotAllConfigurations = function () {
            if (hbNamespace.userConfig && hbNamespace.genericConfig && hbNamespace.companyBrandingData) {
                objectShallowAssign(hbNamespace.userConfig.company, hbNamespace.companyBrandingData);
                hbNamespace.handleForms(hbNamespace.userConfig);

            }
        };

        hbNamespace.loadPlacement = function () {
            if (!hbNamespace.userConfig && !hbNamespace.isInPreviewMode()) {
                hbNamespace.userConfigFilePath = hbNamespace.basePath + hbNamespace.pid + '/' + 'user_config_' + hbNamespace.pid + '.js';
                hbNamespace.loadScript(hbNamespace.userConfigFilePath); // this is a jsonp file
            }
        };

        hbNamespace.loadCompanyBranding = function () {
            if (!hbNamespace.companyBrandingData && !hbNamespace.isInPreviewMode()) {
                hbNamespace.userCompanyBrandingFilePath = hbNamespace.basePath + hbNamespace.pid + '/' + 'company_branding.js';
                var brandingDataScript = hbNamespace.loadScript(hbNamespace.userCompanyBrandingFilePath); // this is a jsonp file

                brandingDataScript.onerror = function (e) {
                    // The user branding data was not fetched so we won't have the full inactive message details but
                    // we still want to show the user the page with the message.
                    hbNamespace.companyBrandingData = {};
                    console.error(e);

                    hbNamespace.runIfGotAllConfigurations();
                }
            }
        };

        hbNamespace.findContactForm = function (contactFormId) {
            return hbNamespace.userConfig.contact_forms.find(function (currContactForm) {
                return currContactForm._id === contactFormId
            });
        };

        hbNamespace.iframeEventHandler = function (e) {
            if (!e.data.hbEvent) { return; }
            var embeddedIframe = "";
            var divStartLocation = "";
            var hbEventData = e.data.hbEvent

            switch (e.data.hbEvent.type) {
                case 'hb_contact_form_mounted':

                    if (hbNamespace.isInPreviewMode()) {
                        break;
                    }
                    var contactForm = hbNamespace.findContactForm(e.data.hbEvent.contact_form_id);

                    hbNamespace.renderContactForm(contactForm, hbNamespace.userConfig.company, hbNamespace.userConfig, {});

                    break;
                case 'hb_contact_form_resize':
                    hbNamespace.triggerIframeResize();
                    break;

                case 'hb_payment_token_received':
                    hbNamespace.redirectToPay(e.data.hbEvent);
                    break;
                case 'hb_stale_contact_form_error':
                    hbNamespace.userConfig = null;
                    hbNamespace.loadPlacement(true);
                    break;
                // START OF BACKWARDS COMPATIBILITY BLOCK
                // This only exists for backwards compatibility, TODO: remove when safe
                case 'hb_page_changed':
                    embeddedIframe = hbNamespace.iframeElements[hbEventData.id];
                    embeddedIframe.style.height = hbEventData.pageHeight / 0.9 + 'px';
                    divStartLocation = embeddedIframe.getBoundingClientRect().y; // was div.getBoundingClientRect
                    var targetYLocation = window.scrollY + divStartLocation - this.screen.availHeight / 4;
                    this.scrollTo({ top: targetYLocation, behavior: 'smooth' });
                    break;
                // END OF BACKWARDS COMPATIBILITY BLOCK
                case 'hb_resize':
                    embeddedIframe = hbNamespace.iframeElements[hbEventData.id];
                    embeddedIframe.style.height = hbEventData.height + 'px';
                    break;
                case 'hb_scroll_to_top':
                    embeddedIframe = hbNamespace.iframeElements[hbEventData.id];
                    divStartLocation = embeddedIframe.getBoundingClientRect().y; // was div.getBoundingClientRect
                    var yPosition = window.scrollY + divStartLocation - this.screen.availHeight / 4;
                    this.scrollTo({ top: yPosition, behavior: 'smooth' });
                    break;
                case 'hb_scroll_to_element':
                    embeddedIframe = hbNamespace.iframeElements[hbEventData.id];
                    divStartLocation = embeddedIframe.getBoundingClientRect().y; // was div.getBoundingClientRect
                    var targetElementYRelativeLocation = hbEventData.elementBoundingClientRect.y;
                    var targetElementHeight = hbEventData.elementBoundingClientRect.height;
                    targetYLocation = window.scrollY + divStartLocation + targetElementYRelativeLocation - this.screen.availHeight / 2 + targetElementHeight / 2;
                    this.scrollTo({ top: targetYLocation, behavior: 'smooth' });
                    break;
            }
        };

        hbNamespace.redirectToPay = function (hbEvent) {
            var url = hbNamespace.runtimeConfig.client_portal_url + 'pay/' + hbEvent.hb_token;
            window.location = url;
        };

        hbNamespace.postContactFormData = function (contactForm, company, userConfig, runtimeConfigOverwrite) {
            if (!hbNamespace.iframeElements[contactForm._id].contentWindow) {
                return;
            }

            hbNamespace.iframeElements[contactForm._id].contentWindow.postMessage({
                hbEvent: {
                    type: 'hb_contact_form_json',
                    contact_form: contactForm,
                    placement_id: hbNamespace.pid,
                    placement_data_version: userConfig.data_version,
                    placement_schema_version: userConfig.schema_version,
                    runtimeConfig: hbNamespace.runtimeConfig,
                    runtimeConfigOverwrite: runtimeConfigOverwrite,
                    company: company,
                    genericConfig: hbNamespace.genericConfig,
                    collector_data: {
                        referrer: document.referrer,
                        location: document.location.href
                    }
                }
            }, "*");
        };

        hbNamespace.renderContactForm = function (contactForm, company, userConfig, runtimeConfigOverwrite) {
            if (!hbNamespace.iframeElements[contactForm._id]) {
                return;
            }

            hbNamespace.postContactFormData(contactForm, company, userConfig, runtimeConfigOverwrite);
        };

        hbNamespace.runSnippet = function () {
            if (!hbNamespace.iframeElements) {
                hbNamespace.iframeElements = {};
            }
            hbNamespace.loadScript(hbNamespace.genericConfigBasePath + hbNamespace.genericConfigFile); // this is a jsonp file
            hbNamespace.loadCompanyBranding();
            hbNamespace.loadPlacement();

            if (!hbNamespace.isEventLsnrOn) {
                hbNamespace.isEventLsnrOn = true;
                window.addEventListener('message', hbNamespace.iframeEventHandler);
            }
        };

        hbNamespace.docReady(function () {
            hbNamespace.runSnippet();
        });

        // the intersection observer observes the contact form wrapper
        // and performs a callback when the contact form is revealed
        // this callback calls iFrameResizer.resize() causing the form to
        // calculate it's correct height 
        hbNamespace.registerIntersectionObserver = function (contactFormId, hbWrapper) {
            const MIN_VIABLE_CF_HEIGHT = 100; // If a CF's height is less then 100 we assume it needs resizing

            if (!('IntersectionObserver' in window) ||
                !('IntersectionObserverEntry' in window) ||
                !('intersectionRatio' in window.IntersectionObserverEntry.prototype)) {
                return;
            }

            var contactForm = hbNamespace.iframeElements[contactFormId];
            var observer = new IntersectionObserver(function (entries) {
                entries.forEach(function (entry) {
                    if (
                        entry.isIntersecting &&
                        !!contactForm &&
                        contactForm.offsetHeight < MIN_VIABLE_CF_HEIGHT
                    ) {
                        contactForm.iFrameResizer.resize();
                    }
                });
            }, {});

            observer.observe(hbWrapper);
        };
    }

})();