<?php
header("Content-Type: application/json");
require 'db.php';

 $method = $_SERVER['REQUEST_METHOD'];

// 1. GET: Ambil semua data
if ($method === 'GET') {
    $stmt = $conn->query("SELECT * FROM landing_pages ORDER BY id DESC");
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($result);
}

// 2. POST: Simpan data baru
if ($method === 'POST') {
    $data = json_decode(file_get_contents("php://input"));
    
    if(!empty($data->domain) && !empty($data->title)) {
        $sql = "INSERT INTO landing_pages (domain, title, description, link) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        
        if($stmt->execute([$data->domain, $data->title, $data->description, $data->link])) {
            echo json_encode(["message" => "Data berhasil disimpan", "id" => $conn->lastInsertId()]);
        } else {
            echo json_encode(["message" => "Gagal menyimpan"]);
        }
    } else {
        echo json_encode(["message" => "Data tidak lengkap"]);
    }
}

// 3. DELETE: Hapus data
if ($method === 'DELETE') {
    $id = $_GET['id'];
    $stmt = $conn->prepare("DELETE FROM landing_pages WHERE id = ?");
    if($stmt->execute([$id])) {
        echo json_encode(["message" => "Data dihapus"]);
    }
}
?>