var CHITIKA_ADS = window.CHITIKA_ADS ? window.CHITIKA_ADS : (function() {
    "use strict";
    var already_bridged     = false;
    var ch_amm_version      = "4.1";
    var host                = 'mm.chitika.net';
    var lightbox_modal      = undefined;
    var lightbox_container  = undefined;
    var lightbox_units      = {};
    var mobile              = undefined;
    var previous_format     = [];
    var publisher           = undefined;
    var size_screen         = undefined;
    var size_scroll         = undefined;
    var size_viewport       = undefined;
    var snippet_cache       = undefined;
    var snippet_count       = 1;
    var snippet_length      = 100;
    var snippet_priority    = ['title', 'h1', 'keywords', 'description'];
    var url_data_cache      = undefined;

    // For a long time we gave silly instructions to tell is by
    // parameter some default colors. That's a waste of time.
    // Skip them.
    var default_params = {
        'color_bg'          : '^#?ffffff',
        'color_border'      : '^#?ffffff',
        'color_site_link'   : '^#?0000cc',
        'color_text'        : '^#?000000',
        'color_title'       : '^#?0000cc',
        'type'              : '^mpu$'
    };

    var lightbox_config     = {
        'border'            : '1px solid #acacac',
        'borderRadius'      : '1px',
        'boxShadow'         : '0px 0px 10px 5px #a2a2a2',
        'cid'               : undefined,
        'close_image'       : 'url(http://images.chitika.net/buttons/close_metro.png)',
        'close_width'       : '18px',
        'close_height'      : '18px',
        'close_top'         : '5px',
        'close_right'       : '5px',
        'height_max'        : 500,
        'height_min'        : 180,
        'height_percent'    : 0.6,
        'modal_color'       : '#888888',
        'modal_opacity'     : 0.40,
        'padding'           : '20px 10px 10px 10px',
        'sid'               : 'lightbox',
        'width_max'         : 700,
        'width_min'         : 300,
        'width_percent'     : 0.65
    };

    function add_script(url, d) {
        if (d === undefined) {d = document;}
        if (typeof(url) !== 'string') {return undefined;}
        var h = d.getElementsByTagName('head')[0];
        if (!h) {return undefined;}
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.src = url;
        h.appendChild(s);
        return s;
    }

    var amm_getads_map = {
        'ch_alternate_ad_url'       : 'alternate_ad_url',
        'ch_alternate_css_url'      : 'alternate_css_url',
        'ch_cid'                    : 'cid',
        'ch_city'                   : 'city',
        'ch_client'                 : 'publisher',
        'ch_color_bg'               : 'color_bg',
        'ch_color_border'           : 'color_border',
        'ch_color_site_link'        : 'color_site_link',
        'ch_color_text'             : 'color_text',
        'ch_color_title'            : 'color_title',
        'ch_fluidH'                 : 'fluidH',
        'ch_fluidW'                 : 'fluidW',
        'ch_font_text'              : 'font_text',
        'ch_font_title'             : 'font_title',
        'ch_height'                 : 'height',
        'ch_hq'                     : 'hq',
        'ch_nump'                   : 'nump',
        'ch_queries'                : 'queries',
        'ch_query'                  : 'query',
        'ch_sid'                    : 'sid',
        'ch_state'                  : 'state',
        'ch_target'                 : 'target',
        'ch_third_party_tracker'    : 'third_party_tracker',
        'ch_type'                   : 'type',
        'ch_where'                  : 'where',
        'ch_width'                  : 'width',
        'ch_zip'                    : 'zip'
    };

    function append_func(obj, event, fun) {
        if (obj.addEventListener) {
            obj.addEventListener(event, fun, false);
        } else {
            obj.attachEvent('on' + event, fun);
        }
    }

    function attach_close(container, properties, fun) {
        var button = document.createElement('a');
        button.href = "#chitika_close_button";
        button.style.background = "url(http://images.chitika.net/buttons/close_round_white_on_red.png)";
        button.style["background-repeat"] = 'no-repeat';
        button.style.height = "14px";
        button.style.position = "absolute";
        button.style.right = "0px";
        button.style.top = "0px";
        button.style.width = "16px";
        button.style.zIndex = "999999";

        // Set optional properties on the new button.
        if (typeof(properties) == 'object') { set_properties(button, properties); }

        append_func(button, 'click', fun);
        container.appendChild(button);
    }

    // Backwards compat for amm.js
    function bridge_amm() {
        var w = window;
        // 0: Bail out if backcompat not necessary
        if (w.ch_client === undefined) return;

        // 1: Make sure we have a units array.
        w.chitika_units = w.chitika_units ? w.chitika_units : [];
        var unit = {};

        // 2: Map parameters into a unit instruction.
        for (var n in amm_getads_map) {
            var mapped = amm_getads_map[n];
            var value = w[n];
            if (typeof(value) !== 'function') {
                unit[mapped] = value;
            }
        }

        // 3: Identify the impsrc specially.
        unit['impsrc'] = def(w.ch_impsrc, 'amm-getads-bridge');

        // 4: Save the unit instruction.
        var r = w.chitika_units.length;
        w.chitika_units[r] = unit;

        // 5: Write the div beacon.
        document.write('<div id="chitikaAdBlock-'+r+'"></div>');

        // 6: Clear global variables.
        w.ch_alternate_ad_url = undefined;
        w.ch_alternate_css_url = undefined;
        w.ch_cid = undefined;
        w.ch_city = undefined;
        w.ch_fluidH = undefined;
        w.ch_fluidW = undefined;
        w.ch_height = undefined;
        w.ch_impsrc = undefined;
        w.ch_metro_id = undefined;
        w.ch_nump = undefined;
        w.ch_query = undefined;
        w.ch_sid = undefined;
        w.ch_state = undefined;
        w.ch_type = undefined;
        w.ch_where = undefined;
        w.ch_width = undefined;
        w.ch_zip = undefined;
    }

    // Set the callback function within the iframe.
    function create_callback(unit_id) {
        var frame = window.chitika_units[unit_id].frame;
        return function(response) {
            if (response === undefined) {
                frame.style.display = 'none';
                // Make sure you always close your iframe no matter what!
                frame.contentWindow.document.close();
                return;
            }

            render_ad_basic(response);
            render_ad_hover(response);
            render_ad_inject_content(response);
            render_ad_js(response);
            render_ad_pixels(response);
            setTimeout(handle_resize, 20);
        }
    }

    ////////////////////////////////////////////////////////////////
    // Shorthand for creating an iframe element.
    function create_iframe(parameters) {
        // Make sure we have a parameters object, even if it's empty.
        if (parameters === undefined) {
            parameters = {};
        }

        // Set default parameter values; use def here to avoid overriding supplied parameters
        parameters.allowTransparency    = def(parameters.allowTransparency, 'allowTransparency');
        parameters.border               = def(parameters.border,        '0');
        parameters.className            = def(parameters.className,     '');
        parameters.frameBorder          = def(parameters.frameBorder,   '0');
        parameters.height               = def(parameters.height,        '0');
        parameters.hspace               = def(parameters.hspace,        '0');
        parameters.marginHeight         = def(parameters.margineHeight, '0');
        parameters.marginWidth          = def(parameters.marginWidth,   '0');
        parameters.padding              = def(parameters.padding,       '0');
        parameters.scrolling            = def(parameters.scrolling,     'no');
        parameters.src                  = def(parameters.src,           'about:blank');
        parameters.style                = def(parameters.style,         {});
        parameters.style.margin         = def(parameters.style.margin,  '0');
        parameters.style.padding        = def(parameters.style.padding, '0');
        parameters.vspace               = def(parameters.vspace,        '0');
        parameters.width                = def(parameters.width,         '0');

        // Create the iframe
        var i = document.createElement('iframe');

        // Set the parameters
        set_properties(i, parameters);

        // Return the iframe.
        return i;
    }

    function create_spinner(d, id, properties) {
        var container = d.createElement('div');
        container.id = id;
        set_properties(container, properties);
        var spinner = d.createElement('img');
        spinner.src = '../spinner.gif';
        container.appendChild(spinner);
        return container;
    }

    // def() - If defined, return v, else return def(ault)
    function def(v, def) {
        if (v !== null && v !== undefined) {
            return v;
        }
        else {
            return def;
        }
    }

    // dq() - Return input surrounded by double-quotes
    function dq(s) { return (s !== null) ? '"' + s + '"' : '""'; }

    function get_screen_size() {
        if (size_screen !== undefined) { return size_screen; }
        size_screen = {
            h: screen.height,
            w: screen.width
        }
        return size_screen;
    }

    function get_scroll_size() {
        if (size_scroll !== undefined) { return size_scroll; }
        size_scroll = {
            h: document.documentElement.scrollHeight ||
               document.body.scrollHeight,
            w: document.documentElement.scrollWidth ||
               document.body.scrollWidth
        }
        return size_scroll;
    }

    // get_snippet_data - Gathers snippets of text from the page which can
    // be used for targeting.
    function get_snippet_data() {
        if (snippet_cache) { return snippet_cache; }
        var d       = undefined,
            meta    = undefined,
            h1      = undefined;
        snippet_cache = {};

        // 1. Decide which document scope to search.
        try {
            // Are win in an iframe?
            if (window === window.top) {
                d = document;
            } else {
                // Yes, we are
                d = window.top.document;
            }
        } catch (x) { // Security exception
            d = document;
        }

        // 2. Gather snippets from on-page elements.
        if (d.getElementsByTagName) {
            // 2a. Meta tags (only keywords/description are considered)
            meta = d.getElementsByTagName('meta');
            for (var i = 0; i < meta.length; i++) {
                var name    = meta[i].getAttribute('name'),
                    content = meta[i].getAttribute('content');

                if (name && content) {
                    snippet_cache[name.toLowerCase()] = content;
                }
            }

            // 2b. First H1 tag
            h1 = d.getElementsByTagName('h1');
            if (h1.length > 0) {
                snippet_cache['h1'] = get_text(h1[0]);
            }
        }

        // 3. Grab the title if possible.
        if (d.title) {
            snippet_cache['title'] = d.title;
        }

        // 4. Return it.
        return snippet_cache;
    }

    // Shorthand method of grabbing the text content of an element.
    // Required because IE writes its own standard.
    function get_text(node) {
        var r = '';

        if (node.innerText !== undefined) {
            r = node.innerText;
        } else if (node.textContent !== undefined) {
            r = node.textContent;
        }

        return r;
    }

    function get_url_data() {
        if (url_data_cache !== undefined) { return url_data_cache; }
        var frm, ref, serveUrl, url;
        // Detect iframes and pass appropriate frm & url values
        try {
            // Are win in an iframe?
            if (window === window.top) {
                // Nope. Nothing special here to do.
                ref             = document.referrer;
                url             = document.location.href;
            } else {
                // Yes, we are
                frm             = 1;
                ref             = window.top.document.referrer;
                url             = window.top.document.location.href;
                serveUrl        = document.location.href;
            }
        } catch (x) { // Security exception
            // Security problem. Try something else. Hope this works...
            frm                 = 2;
            url                 = document.referrer;
            serveUrl            = document.location.href;
        }

        if (serveUrl &&
            serveUrl.match(/^javascript:/)) {
            serveUrl = undefined;
        }
        url_data_cache = {
            frm         : frm,
            ref         : ref,
            serveUrl    : serveUrl,
            url         : url
        };
        return url_data_cache;
    }

    function get_viewport_size() {
        if (size_viewport !== undefined) { return size_viewport; }

        var w;
        try {
            w = window.top;
        } catch (e) {
            w = window;
        }

        size_viewport = {
            h   : w.innerHeight ||
                 document.documentElement.clientHeight ||
                 document.body.clientHeight,
            w   : w.innerWidth ||
                  document.documentElement.clientWidth ||
                  document.body.clientWidth
        };
        return size_viewport;
    }

    // If the window is resized, the ad unit my re-flow. We need to adjust
    // the height automatically if this happens.
    function handle_resize() {
        // Dirty our viewport size cache.
        size_viewport = undefined;
        // Reflow units and recalc size.
        for (var unit_id = 0; unit_id < window.chitika_units.length; unit_id++) {
            var unit = window.chitika_units[unit_id];
            if (unit.fluidH) {
                var frame = unit.frame;
                if (!frame ||
                    !frame.contentWindow ||
                    !frame.contentWindow.document) {
                    continue;
                }
                var h1 = frame.contentWindow.document.documentElement.scrollHeight ||
                         frame.contentWindow.document.body.scrollHeight;
                var h2 = unit.height;
                if (h1 != h2) {
                    unit.height = h1;
                    frame.style.height = h1 + "px";
                }
            }
            if (!unit.already_visible &&
                !unit.disable_vcpm) {
                unit.loc = locate_obj(unit.container);
            }
        }
        if (lightbox_container &&
            lightbox_container.style.display == 'block') {
            lightbox_show();
        }
    }

    // ldef() - Return the first argument that isn't undefined
    function ldef() {
        for (var i = 0; i < arguments.length; i++) {
            if (arguments[i] !== undefined) {
                return arguments[i];
            }
        }
        return undefined;
    }

    function lightbox(impId, index, query) {
        var top;
        try {
            top = window.top;
        } catch(e) { return; }

        if (lightbox_modal === undefined) {
            lightbox_modal = top.document.createElement('div');
            lightbox_modal.id = 'chitika-modal';
            set_properties(lightbox_modal.style, {
                'allowTransparency' : 'allowTransparency',
                'backgroundColor'   : lightbox_config.modal_color,
                'display'           : 'none',
                'filter'            : 'alpha(opacity='+lightbox_config.modal_opacity*100+')',
                'opacity'           : lightbox_config.modal_opacity,
                'position'          : 'fixed',
                'top'               : '0',
                'right'             : '0',
                'bottom'            : '0',
                'left'              : '0',
                'zIndex'            : '999',
                'zoom'              : '1'
            });
            append_func(lightbox_modal, 'click', lightbox_hide);
            top.document.body.appendChild(lightbox_modal);

            var l = ['height', 'width'];
            var viewport_size_data = get_viewport_size();
            for (var c = 0; c < 2; c++) {
                var k = l[c];
                if (lightbox_config[k]) { continue; }
                lightbox_config[k] = Math.floor(viewport_size_data[(k == 'width' ? 'w' : 'h')] * lightbox_config[k+'_percent']);
                if (lightbox_config[k] > lightbox_config[k+'_max']) {
                    lightbox_config[k] = lightbox_config[k+'_max'];
                } else if (lightbox_config[k] < lightbox_config[k+'_min']) {
                    lightbox_config[k] = lightbox_config[k+'_min'];
                }
            }

            lightbox_container = top.document.createElement('div');
            lightbox_container.id = 'chitika-modal-container';
            set_properties(lightbox_container.style, {
                'backgroundColor'   : '#FFFFFF',
                'border'            : lightbox_config.border,
                'borderRadius'      : lightbox_config.borderRadius,
                'boxShadow'         : lightbox_config.boxShadow,
                'margin'            : 'auto auto',
                'padding'           : lightbox_config.padding,
                'position'          :'fixed',
                'zIndex'            : '9999'
            });
            CHITIKA_ADS.attach_close(
                lightbox_container,
                {
                    'style'     : {
                        'background': lightbox_config.close_image,
                        'height'    : lightbox_config.close_height,
                        'right'     : lightbox_config.close_right,
                        'top'       : lightbox_config.close_top,
                        'width'     : lightbox_config.close_width
                    }
                },
                lightbox_hide
            );
            top.document.body.appendChild(lightbox_container);
            lightbox_container.appendChild(create_spinner(top.document, 'chitika-spinner-lightbox'));
        }
        if (lightbox_units[index] === undefined) {
            top.document.getElementById('chitika-spinner-lightbox').style.display = 'block';
            var frame_name = 'chitikaLightbox-'+index;
            var unit = {
                'cid'               : lightbox_config.cid,
                'container'         : lightbox_container,
                'disable_vcpm'      : true,
                'frame'             : create_iframe({
                    'className'     : 'chitikaLightboxFrame',
                    'height'        : lightbox_config.height,
                    'id'            : frame_name,
                    'width'         : lightbox_config.width
                }),
                'height'            : lightbox_config.height,
                'impId'             : impId,
                'product'           : 'lightbox',
                'query'             : query,
                'sid'               : lightbox_config.sid,
                'width'             : lightbox_config.width
            }
            window.chitika_units.push(unit);
            lightbox_units[index] = unit;

            var frame = unit.frame;
            lightbox_container.appendChild(frame);
            write_empty_document(frame.contentWindow.document);
            unit.frame.contentWindow.render_ad = lightbox_callback;
            make_ad_server_call();
        } else {
            lightbox_units[index].frame.style.display = 'block';
        }
        lightbox_show();
    }

    function lightbox_callback(response) {
        if (response === undefined ||
            (!response.output &&
             !response.alturl)) {
            lightbox_hide();
        }
        var unit = chitika_units[response.unit_id];
        var frame = unit.frame;

        document.getElementById('chitika-spinner-lightbox').style.display = 'none';
        render_ad_inject_content(response);
        unit.frame.style.display = 'block';
    }

    function lightbox_show() {
        var viewport_size_data = get_viewport_size();
        var boxOffsetLeft = (viewport_size_data.w - lightbox_config.width)/2;
        var boxOffsetTop = (viewport_size_data.h - lightbox_config.height)/2;

        lightbox_container.style.left = boxOffsetLeft+'px',
        lightbox_container.style.top = boxOffsetTop+'px',
        lightbox_container.style.display = 'block';
        lightbox_modal.style.display = 'block';
    }

    function lightbox_hide() {
        for (var uid in lightbox_units) {
            lightbox_units[uid].frame.style.display = 'none';
        }
        lightbox_container.style.display = 'none';
        lightbox_modal.style.display = 'none';
        return false;
    }

    // locate_obj() - walks the DOM tree from obj, accumulating offset left
    // and top to find X, Y position for obj
    function locate_obj(obj) {
        var _x = 0;
        var _y = 0;
        var _w = 0;
        var _h = 0;
        _w = obj.offsetWidth;
        _h = obj.offsetHeight;
        while (obj &&
               !isNaN(obj.offsetLeft) &&
               !isNaN(obj.offsetTop)) {
            _x += obj.offsetLeft - obj.scrollLeft;
            _y += obj.offsetTop - obj.scrollTop;
            obj = obj.offsetParent;
        }
        return { y: _y, x: _x, w: _w, h: _h };
    }

    function make_ad_server_call() {
        var screen_size_data    = get_screen_size(),
            scroll_size_data    = get_scroll_size(),
            snippet_data        = get_snippet_data(),
            url_data            = get_url_data(),
            viewport_size_data  = get_viewport_size();

        for (var unit_id = 0; unit_id < window.chitika_units.length; unit_id++) {
            var unit            = window.chitika_units[unit_id];
            if (unit.already_fired) { continue; }
            unit.already_fired = true;

            // 3.1: Initial URI for ad request.
            var ad_url = 'http://' + CHITIKA_ADS.host + '/minimall?output=jsonp';

            // 3.2: Critical identification parameters.
            ad_url = param_concat_escape(ad_url, 'publisher',           CHITIKA_ADS.publisher);
            ad_url = param_concat_escape(ad_url, 'sid',                 unit.sid);
            ad_url = param_concat_words(ad_url, 'cid',                  unit.cid);
            ad_url = param_concat(ad_url, 'unit_id',                    unit_id);
            ad_url = param_concat_escape(ad_url, 'product',             unit.product);
            ad_url = param_concat_escape(ad_url, 'w',                   unit.width);
            ad_url = param_concat_escape(ad_url, 'h',                   unit.height);
            ad_url = param_concat_escape(ad_url, 'nump',                unit.nump);
            ad_url = param_concat_escape(ad_url, 'type',                unit.type);
            ad_url = param_concat_escape(ad_url, 'impId',               unit.impId);
            ad_url = param_concat_escape(ad_url, 'extra_subid_info',    unit.extra_subid_info);

            // 3.3: Info about where we are on the internet.
            for (var k in url_data) {
                var v = url_data[k];
                var v2;
                if (unit.omg !== undefined) {
                    v2 = unit.omg[k];
                    if (v2 && v2 != v) {
                        ad_url = param_concat(ad_url, 'omg_'+k, 1);
                        v = v2;
                    }
                }
                ad_url = param_concat_escape(ad_url, k, v);
            }

            // 3.4: Some publisher settings.
            ad_url = param_concat_escape(ad_url, 'altcss',              unit.alternate_css_url);
            ad_url = param_concat_escape(ad_url, 'alturl',              unit.alternate_ad_url);
            ad_url = param_concat_escape(ad_url, 'cttarget',            unit.target);
            ad_url = param_concat_escape(ad_url, 'tptracker',           unit.third_party_tracker);

            // 3.5: Targetting data.
            ad_url = param_concat_escape(ad_url, 'query',               unit.query);
            ad_url = param_concat_escape(ad_url, 'where',               unit.where);
            ad_url = param_concat_escape(ad_url, 'city',                unit.city);
            ad_url = param_concat_escape(ad_url, 'state',               unit.state);
            ad_url = param_concat_escape(ad_url, 'zip',                 unit.zip);
            if (unit.queries &&
                unit.queries.constructor.toString().indexOf("Array") !== -1) {
                ad_url = param_concat_escape(ad_url, 'mquery', unit.queries.join('|'));
            }

            // 3.6: Visual configuration parameters.
            ad_url = param_concat_escape(ad_url, 'cl_border',           unit.color_border);
            ad_url = param_concat_escape(ad_url, 'cl_bg',               unit.color_bg);
            ad_url = param_concat_escape(ad_url, 'cl_title',            unit.color_title);
            ad_url = param_concat_escape(ad_url, 'cl_text',             unit.color_text);
            ad_url = param_concat_escape(ad_url, 'cl_site_link',        unit.color_site_link);
            ad_url = param_concat_escape(ad_url, 'fn_title',            unit.font_title);
            ad_url = param_concat_escape(ad_url, 'fn_text',             unit.font_text);

            // 3.7: Data attributes.
            ad_url = param_concat(ad_url, 'dpr',                        window.devicePixelRatio);
            ad_url = param_concat_escape(ad_url, 'impsrc',              unit.impsrc);
            ad_url = param_concat_escape(ad_url, 'history',             history.length);
            ad_url = param_concat_escape(ad_url, 'previous_format',     previous_format.join(','));
            ad_url = param_concat_escape(ad_url, 'size_screen',         screen_size_data.w+'x'+screen_size_data.h);
            ad_url = param_concat_escape(ad_url, 'size_scroll',         scroll_size_data.w+'x'+scroll_size_data.h);
            ad_url = param_concat_escape(ad_url, 'size_viewport',       viewport_size_data.w+'x'+viewport_size_data.h);
            ad_url = param_concat_escape(ad_url, 'vsn',                 ch_amm_version);

            // 3.8 Anything extra.
            if (unit.extra_params !== undefined) {
                for (var i = 0; i < unit.extra_params.length; i++) {
                    var a = unit.extra_params[i];
                    ad_url = param_concat_escape(ad_url, a.k, a.v);
                }
            }

            // 3.9: Indicate Chrome prerendering mode.
            if (navigator.userAgent.match(/Chrome/) &&
                document.webkitVisibilityState !== undefined &&
                document.webkitVisibilityState == "prerender") {
                ad_url = param_concat(ad_url, 'prerender', 1);
            }

            // 3.10: Include some targetting data from the local page.
            var count = 0;
            for (var i = 0; i < snippet_priority.length && count < snippet_count; i++) {
                var id = snippet_priority[i];
                if (snippet_data[id]) {
                    ad_url = param_concat_escape(ad_url, 'snip_' + id, snippet_data[id].substring(0, snippet_length));
                    ++count;
                }
            }

            previous_format.push(unit.width + "x" + unit.height);

            unit.loc = locate_obj(unit.container);
            ad_url = param_concat_escape(ad_url, "loc", unit.loc.x + "," + unit.loc.y);

            ad_url = ad_url.substring(0, 2048);       // Trim request URL to 2048 characters
            ad_url = ad_url.replace(/%\w?$/, '');     // Remove any trailing malformed URL encoded character

            if (unit.adurl_fixup !== undefined) {
                ad_url = unit.adurl_fixup(ad_url);
            }

            var frame = unit.frame;
            if (unit.hq) {
                for (var k in unit.hq) {
                    frame.contentWindow[k] = unit.hq[k];
                }
                var hq_file = def(unit.hq_file, CHITIKA_ADS.publisher);
                var s = document.createElement('script');
                s.type = 'text/javascript';
                s.src = 'http://tags.chitika.net/hq/' + hq_file + '.js';
                s.ad_url = ad_url;
                s._target = frame.contentWindow;
                s._fired = false;

                s.onload = function() {
                    if (this.has_fired) return;
                    window.ch_target_window = this._target;
                    window.ch_real_ad_url = this.ad_url;
                    window.ch_hq_execute();
                    this.has_fired = true;
                }
                s.onreadystatechange = function() {
                    if (this.has_fired) return;
                    if (this.readyState == "complete" || this.readyState == "loaded") {
                        window.ch_target_window = this._target;
                        window.ch_real_ad_url = this.ad_url;
                        window.ch_hq_execute();
                        this.has_fired = true;
                    }
                }

                document.getElementsByTagName('head')[0].appendChild(s);
            } else {
                add_script(ad_url, frame.contentWindow.document);
            }
        }
    }

    function make_it_so() {
        prepare_containers();
        prepare_instructions();
        make_ad_server_call();
    }

    function mobile_type() {
        if (mobile !== undefined) { return mobile; }
        if (/i[Pp]ad/.test(navigator.userAgent)) {
            mobile = 2;
        }
        else if (/i[Pp]od/.test(navigator.userAgent)) {
            mobile = 4;
        }
        else if (/i[Pp]hone/.test(navigator.userAgent)) {
            mobile = 1;
        }
        else if (/[Aa]ndroid/.test(navigator.userAgent)) {
            mobile = 3;
        }
        else if (/BlackBerry|RIM/.test(navigator.userAgent)) {
            mobile = 5;
        }
        else {
            mobile = 0;
        }
        return mobile;
    }

    function param_concat(url, p, v) {
        if (!v && v !== 0) { return url; }
        return url + '&' + p + '=' + v;
    }

    function param_concat_escape(url, p, v) {
        if (!v && v !== 0) { return url; }
        return url + '&' + p + '=' + encodeURIComponent(v);
    }

    function param_concat_words(url, p, v) {
        if (!v && v !== 0) { return url; }
        v = v.replace(/[\W]+/, '_');
        return url + '&' + p + '=' + encodeURIComponent(v);
    }

    function prepare_containers() {
        for (var unit_id = 0; unit_id < window.chitika_units.length; unit_id++) {
            var frame_name  = "ch_ad" + unit_id;
            var unit        = window.chitika_units[unit_id];
            if (unit.container && unit.frame) { continue; }

            unit.container  = document.getElementById('chitikaAdBlock-' + unit_id);
            unit.frame      = create_iframe({
                'class':                'chitikaAdBlock',
                'height':               (typeof(unit.height) === 'string' ? 0 : def(unit.height, 0)),
                'id':                   frame_name,
                'name':                 frame_name,
                'width':                unit.width
            });
            unit.container.appendChild(unit.frame);
            write_empty_document(unit.frame.contentWindow.document);
            unit.frame.contentWindow.render_ad = create_callback(unit_id);
        }
    }

    function prepare_instructions() {
        for (var unit_id = 0; unit_id < window.chitika_units.length; unit_id++) {
            var unit = window.chitika_units[unit_id];
            if (unit.already_fired) { continue; }

            // 2.1: s/client/publisher/. Imposed vocabulary correction.
            if (unit.client) {
                unit.publisher = unit.client;
                unit.client = undefined;
            }

            // 2.2: Save a reference to the publisher name. All units get
            //      the same publisher name on a given page. NO EXCEPTIONS.
            if (unit_id == 0) {
                CHITIKA_ADS.publisher = unit.publisher;
            }

            // 2.3: I regret the entire year 2009.
            if (unit.publisher == 'epodunk') {
                if (m = window.location.hostname.match(/([^\.]+)\.(com|net|org|info|mobi|co\.uk|org\.uk|ac\.uk|uk)$/)) {
                    unit.sid = 'epodunk_' + m[1];
                }
            }

            // 2.4: Make sure we have a CID for automated identification.
            if (!unit.cid) {
                if (!unit.sid ||
                    unit.sid == 'Chitika Default') {
                    unit.cid = 'unit-'+unit_id;
                }
                else {
                    unit.cid = unit.sid;
                }
            }

            // 2.5: Make sure we identify the traffic generator.
            unit.impsrc = def(unit.impsrc, "getads");

            // 2.6: Remove default parameter values. They waste log space.
            for (var p in default_params) {
                var c = default_params[p];
                if (!unit[p]) { continue; }
                if (unit[p].match(new RegExp(c, "i"))) { unit[p] = undefined; }
            }

            // 2.7: Rename the extra_params thing to something that makes sense.
            if (unit.minimall !== undefined) {
                unit.extra_params = unit.minimall;
                unit.minimall = undefined;
            }
        }
    }

    function render_ad_basic(response) {
        var unit_id = response.unit_id;
        var unit = window.chitika_units[unit_id];

        if (unit_id === 0) {
            append_func(window, 'scroll', visibility_check);
        }

        if (response.disable_vcpm) {
            unit.disable_vcpm = true;
        }

        if (response.fluidH) {
            unit.fluidH = true;
        }

        if (response.fluidW) {
            unit.fluidW = true;
        }

        unit.impId = response.impId;
        unit.navajo = response.navajo;

        if (response.lightbox) {
            unit.frame.contentWindow.lightbox = lightbox;
            unit.frame.contentWindow.lightbox_config = lightbox_config;
        }
    }

    function render_ad_hover(response) {
        if (!response.hover) { return; }
        try {
            top.window.ch_mmhtml = {};
            top.window.ch_mmhtml.hover = response.hover;
            top.window.ch_mmhtml.publisher = response.publisher;
            add_script('http://maps-static.chitika.net/js/m.js',
                       top.window.document);
        } catch(e) {}
    }

    function render_ad_inject_content(response) {
        var unit_id = response.unit_id;
        var unit = window.chitika_units[unit_id];
        var container = unit.container;
        var frame = unit.frame;

        if (response.output) {
            if (unit.fluidW) {
                container.style.width = "auto";
                container.style.overflow = "hidden";
                frame.style.width = "100%";
            }

            try {
                frame.contentWindow.document.open();
                frame.contentWindow.document.write(response.output);
                frame.contentWindow.document.close();
            } catch (e) {
                // Fallback method of writing into an iframe.
                frame.contentWindow.document.innerHTML = response.output;
            }

            if (!unit.disable_vcpm) { visibility_check(); }
        } else if (response.alturl) {
            frame.src = response.alturl;
            unit.disable_vcpm = false;
        } else {
            frame.style.display = 'none';
            frame.contentWindow.document.close();
            unit.disable_vcpm = false;
        }
    }

    function render_ad_js(response) {
        if (!response.js) { return; }
        for (var i = 0; i < response.js.length; i++) {
            var url = response.js[i];
            try { add_script(url, top.window.document); } catch(e) {}
        }
    }

    function render_ad_pixels(response) {
        if (!response.pixels) { return; }
        for (var i = 0; i < response.pixels.length; i++) {
            var url = response.pixels[i];
            var fimg = document.createElement("img");
            fimg.border = 0;
            fimg.style.border = 'none';
            fimg.style.display = 'none';
            fimg.width = 1;
            fimg.height = 1;
            fimg.src = url;
            document.body.appendChild(fimg);
        }
    }

    function send_event(event_name, impId, metadata) {
        var url_data = get_url_data();
        var url = 'http://mm.chitika.net/chewey?type='+event_name;
        url = param_concat_escape(url, 'publisher', CHITIKA_ADS.publisher);
        url = param_concat_escape(url, 'impId', impId);
        url = param_concat_escape(url, 'url', url_data.url);
        if (metadata) {
            for (var k in metadata) {
                var v = metadata[k];
                url = param_concat_escape(url, k, v);
            }
        }
if (Math.random() < 0.6) {
        var pixel = new Image(1, 1);
        pixel.src = url;
        pixel.style.display = 'none';
}
    }

    // Define a function for setting iframe attributes from a hash. Needs to function
    // recursively for properties like style.
    function set_properties(o, p) {
        for (var k in p) {
            var v = p[k];
            if (v === undefined) { continue; }
            if (typeof v === 'function') { continue; }
            if (typeof v === 'object') {
                set_properties(o[k], v);
            } else {
                o[k] = v;
            }
        }
    }

    function visibility_check() {
        var offset_h = document.documentElement.scrollTop ||
                       document.body.scrollTop;
        var viewport_size_data = get_viewport_size();
        for (var c = 0; c < window.chitika_units.length; c++) {
            var unit = window.chitika_units[c];
            // 1: Get info about where we are and where the unit is.
            if (unit.already_visible || unit.disable_vcpm) { continue; }
            var h = unit['height'];
            if (h == 'auto') { h = 200; } // protect from h=auto
            var y = unit['loc']['y'];

            // 2: Skip if we're not 50% in that visible area.
            if (y < (offset_h - (0.5*h)) ||
                y > (offset_h + viewport_size_data['h'] - (0.5*h))) {
                continue;
            }

            // 3: Send event.
            var metadata = {
                unit_id     : c,
                h           : h,
                offset_h    : offset_h,
                sid         : unit['sid'],
                viewport_h  : viewport_size_data['h'],
                xargs       : unit.navajo,
                y           : y
            };
            send_event('imp_visible', unit['impId'], metadata);

            // 4: Mark as already visible.
            unit['already_visible'] = true;
        }
    }

    function write_empty_document(d) {
        // We need to write an empty document into our iframe, else
        // you won't be able to inject a <script> into its head. Only
        // a problem with certain ::cough MSIE:: browsers.
        // NOTE: The contentWindow doesn't exist until the object is in
        //       the DOM.
        d.write('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd"><html><head></head><body></body></html>');
    }

    append_func(window, 'resize', handle_resize);

    return {
        'add_script'                : add_script,
        'already_bridged'           : already_bridged,
        'append_func'               : append_func,
        'attach_close'              : attach_close,
        'bridge_amm'                : bridge_amm,
        'create_iframe'             : create_iframe,
        'create_spinner'            : create_spinner,
        'def'                       : def,
        'dq'                        : dq,
        'get_screen_size'           : get_screen_size,
        'get_scroll_size'           : get_scroll_size,
        'get_snippet_data'          : get_snippet_data,
        'get_text'                  : get_text,
        'get_url_data'              : get_url_data,
        'get_viewport_size'         : get_viewport_size,
        'host'                      : host,
        'ldef'                      : ldef,
        'locate_obj'                : locate_obj,
        'make_ad_server_call'       : make_ad_server_call,
        'make_it_so'                : make_it_so,
        'mobile_type'               : mobile_type,
        'param_concat_escape'       : param_concat_escape,
        'param_concat'              : param_concat,
        'param_concat_words'        : param_concat_words,
        'publisher'                 : publisher,
        'render_ad_inject_content'  : render_ad_inject_content,
        'set_properties'            : set_properties,
        'write_empty_document'      : write_empty_document
    };
}());

// Schedule execution.
CHITIKA_ADS.bridge_amm();
if (!CHITIKA_ADS.already_bridged) {
    CHITIKA_ADS.already_bridged = true;
    CHITIKA_ADS.append_func(window, 'load', CHITIKA_ADS.make_it_so);
    setTimeout(CHITIKA_ADS.make_it_so, 2000);
}

function ex_normal_op() {
    // Add a javascript tag to the header of the iframe.
    var s = ch_target_window.document.createElement('script');
    s.type = 'text/javascript';
    s.src = ch_real_ad_url;
    ch_target_window.document.getElementsByTagName('head')[0].appendChild(s);
}