var allmarkers = [];
var allvenues = [];
var tab_names = [];

var MapMarker = Class.create({
  initialize: function (currentLong, currentLat, markerHashKey, listing_name, listing_info, listing_counter) {
    this.currentLong = currentLong;
    this.currentLat = currentLat;
    this.markerHashKey = markerHashKey;
    this.listing_name = listing_name;
    this.listing_info = listing_info;
    this.listing_counter = listing_counter
  }
});

var markerOpenWindow = "";
var markerCount = 0;
var markerIconHash = new Array();
var markerHashKey;
var bounds = new GLatLngBounds();

// helper function to create markers
function createMarker(point,title,html) {
    var custom_icon = new GIcon();
    custom_icon.image = "/images/flag"+markerCount+".gif";
    custom_icon.shadow = "/images/flag"+markerCount+".gif";
    custom_icon.iconSize = new GSize(20, 26);
    custom_icon.shadowSize = new GSize(1, 1);
    custom_icon.iconAnchor = new GPoint(17, 25);
    custom_icon.infoWindowAnchor = new GPoint(10, 1);  

    var marker = new GMarker(point, {title:title, icon:custom_icon});
    return marker;
}

function mapMarkerIcon(id, marker_number, marker, info) {
    $('marker'+id).update(marker_number);
    GEvent.addDomListener($('mapinfolink'+id), "mouseover", function () {
      if (markerOpenWindow !="'mapinfolink"+id) {
        markerOpenWindow = "'mapinfolink"+id;
        marker.openInfoWindowTabsHtml(info);
      }
    });    
}

function plotMarker(map, currentLong, currentLat, markerHashKey, listing_name, listing_info, listing_counter) {
  var venue;
  var tabs = [];
  if (!markerIconHash[markerHashKey]) {
    markerCount+=1;
    var latlng = new GLatLng(currentLat, currentLong);
    bounds.extend(latlng);
    venue = createMarker(latlng,listing_name,listing_info);
    map.addOverlay(venue);
    tabs.push(new GInfoWindowTab(listing_name.truncate(10), listing_info));
    markerIconHash[markerHashKey] = [markerCount, venue, tabs];
    tab_names.push(listing_name);
  } else {
    venue = markerIconHash[markerHashKey][1];
    tabs = markerIconHash[markerHashKey][2];
    if (tab_names.indexOf(listing_name) == -1) { // check to see if same location and same venue for event listings
      tabs.push(new GInfoWindowTab(listing_name.truncate(10), listing_info));
      tab_names.push(listing_name);
    }
    markerIconHash[markerHashKey] = [markerIconHash[markerHashKey][0], venue, tabs];
  }
  
  venue.bindInfoWindowTabsHtml(tabs);  
  
  if (listing_counter > 0) {
    mapMarkerIcon(listing_counter,markerIconHash[markerHashKey][0],markerIconHash[markerHashKey][1],tabs);
  } else {
    venue.openInfoWindowHtml(listing_info);
  }
}